; DOS Macros for Ideal mode -- by Tom Swan
%NOLIST

;---------------------------------------------------------------
; MS_DOS                Call any DOS function
;---------------------------------------------------------------
; Input:
;       functionNumber = DOS function number
; Output:
;       depends upon specific function
; Registers:
;       depends upon specific function
;---------------------------------------------------------------
MACRO   MS_DOS  functionNumber
        mov     ah, functionNumber      ;; Assign function number
        int     21h                     ;; Call DOS
ENDM    MS_DOS  functionNumber

;---------------------------------------------------------------
; (01h) DOS_GetChar     Get character with echo
;---------------------------------------------------------------
; Input:
;       none
; Output:
;       al = next character from standard input
; Registers:
;       ax
;---------------------------------------------------------------
MACRO   DOS_GetChar
        mov     ah, 1           ;; Assign DOS function number
        int     21h             ;; Call DOS
ENDM    DOS_GetChar

;---------------------------------------------------------------
; (02h) DOS_PutChar     Write character to standard output
;---------------------------------------------------------------
; Input:
;       dl = ASCII character (0-255)
; Output:
;       none
; Registers:
;       ah
;---------------------------------------------------------------
MACRO   DOS_PutChar
        mov     ah, 2           ;; Assign DOS function number
        int     21h             ;; Call DOS
ENDM    DOS_PutChar

;---------------------------------------------------------------
; (05h) DOS_PrintChar   Send character to standard list device
;---------------------------------------------------------------
; Input:
;       dl = ASCII character (0-255)
; Output:
;       none
; Registers:
;       ah
;---------------------------------------------------------------
MACRO   DOS_PrintChar
        mov     ah, 5           ;; Assign DOS functon number
        int     21h             ;; Call DOS
ENDM    DOS_PrintChar

;---------------------------------------------------------------
; (07h) DOS_GetRawChar  Get unfiltered char with no echo
;---------------------------------------------------------------
; Input:
;       none
; Output:
;       al = next character from standard input
; Registers:
;       ax
;---------------------------------------------------------------
MACRO   DOS_GetRawChar
        mov     ah, 7           ;; Assign DOS function number
        int     21h             ;; Call DOS
ENDM    DOS_GetRawChar

;---------------------------------------------------------------
; (08h) DOS_GetCharNoEcho        Get filtered char with no echo
;---------------------------------------------------------------
; Input:
;       none
; Output:
;       al = next character from standard input
; Registers:
;       ax
;---------------------------------------------------------------
MACRO   DOS_GetCharNoEcho
        mov     ah, 8           ;; Assign DOS function number
        int     21h             ;; Call DOS
ENDM    DOS_GetCharNoEcho

;---------------------------------------------------------------
; (09h) DOS_PutString   Write ASCII$ string to standard output
;---------------------------------------------------------------
; Input:
;       string = label of ASCII$ variable
; Output:
;       none
; Registers:
;       ah, dx
;---------------------------------------------------------------
MACRO   DOS_PutString  string
        mov     ah, 9           ;; Assign DOS function number
        mov     dx, offset string ;; Address string with ds:dx
        int     21h             ;; Call DOS
ENDM    DOS_PutString

;---------------------------------------------------------------
; (0Bh) DOS_Keypressed  Check if a keyboard character is waiting
;---------------------------------------------------------------
; Input:
;       none
; Output:
;       zf = 0 : (jnz) A character is waiting to be read
;       zf = 1 : (jz) No character is waiting
; Registers:
;       ax
;---------------------------------------------------------------
MACRO   DOS_Keypressed
        mov     ah, 0Bh         ;; Assign DOS function number
        int     21h             ;; Call DOS
        or      al, al          ;; Set/clear zf
ENDM    DOS_Keypressed

;---------------------------------------------------------------
; (0Eh) DOS_SetDrive    Change current drive
;---------------------------------------------------------------
; Input:
;       dl = drive number (0=A:, 1=B:, 2=C:, ..., 25=Z:)
;       Note: F: to Z: requires LASTDRIVE=Z in CONFIG.SYS file
; Output:
;       al = total number of drives available
; Registers:
;       ax
;---------------------------------------------------------------
MACRO   DOS_SetDrive
        mov     ah, 0Eh         ;; Assign DOS function number
        int     21h             ;; Call DOS
ENDM    DOS_SetDrive

;---------------------------------------------------------------
; (19h) DOS_GetDrive    Get current drive number
;---------------------------------------------------------------
; Input:
;       none
; Output:
;       al = drive number (0=A:, 1=B:, 2=C:, ..., 25=Z:)
; Registers:
;       ax
;---------------------------------------------------------------
MACRO   DOS_GetDrive
        mov     ah, 19h         ;; Assign DOS function number
        int     21h             ;; Call DOS
ENDM    DOS_GetDrive

;---------------------------------------------------------------
; (25h) DOS_SetVector   Set interrupt vector 
;---------------------------------------------------------------
; Input:
;       interrupt = interrupt number (0-255)
;       address   = label at start of interrupt routine
; Output:
;       none
; Registers:
;       ax, dx
;---------------------------------------------------------------
MACRO   DOS_SetVector  interrupt, address
        push    ds              ;; Save current ds register
        mov     ax, SEG address ;; Assign segment address of
        mov     ds, ax          ;;  interrupt service to ds
        mov     dx, OFFSET address ;; Assign offest address to dx
        mov     ah, 025h        ;; Assign DOS function number
        mov     al, interrupt   ;; Assign interrupt number to al
        int     21h             ;; Call DOS
        pop     ds              ;; Restore ds segment register
ENDM    DOS_SetVector

;---------------------------------------------------------------
; (35h) DOS_GetVector   Get interrupt vector
;---------------------------------------------------------------
; Input:
;       interrupt = interrupt number
; Output:
;       es:bx = segment:offset address of interrupt
; Registers:
;       ax, bx, es
;---------------------------------------------------------------
MACRO   DOS_GetVector  interrupt
        mov     al, interrupt   ;; Assign interrupt number to al
        mov     ah, 35h         ;; Assign DOS function number
        int     21h             ;; Call DOS
ENDM    DOS_GetVector

;---------------------------------------------------------------
; (3Bh) DOS_ChDir       Change current directory
;---------------------------------------------------------------
; Input:
;       dirName = label of ASCIIZ string in ds data segment
; Output:
;       cf = 0 : (jnc) Change was successful
;
;       cf = 1 : (jc) Change was not successful
;       ax = error code (3=directory not found)
; Registers:
;       ax, dx
;---------------------------------------------------------------
MACRO   DOS_ChDir  dirName
        mov     ah, 3Bh         ;; Assign DOS function number
        mov     dx, OFFSET dirName  ;; Assign string address to ds:dx
        int     21h             ;; Call DOS
ENDM    DOS_ChDir

;---------------------------------------------------------------
; (3Ch) DOS_CreateFile  Create new file
;---------------------------------------------------------------
; Input:
;       fileName = label of ASCIIZ string in ds data segment
;       cx = attribute to use in directory
;            00 = normal file
;            01 = read-only (access denied for read/write)
;            02 = hidden (DIR does not show name)
;            04 = system file
; Output:
;       cf = 0 : (jnc) File created
;       ax = file handle for future operations
;
;       cf = 1 : (jc) File not created
;       ax = error code
;            3 = path not found
;            4 = no more handles available
;            5 = access denied
; Registers:
;       ax, dx
;---------------------------------------------------------------
MACRO   DOS_CreateFile  fileName
        mov     ah, 3Ch         ;; Assign DOS function number
        mov     dx, OFFSET fileName  ;; Assign name address to ds:dx
        int     21h             ;; Call DOS
ENDM    DOS_CreateFile

;---------------------------------------------------------------
; (3Dh) DOS_OpenFile    Open file for I/O
;---------------------------------------------------------------
; Input:
;       fileName = label of ASCIIZ string in ds data segment
; Output:
;       cf = 0 : (jnc) File opened
;       ax = file handle for future operations
;
;       cf = 1 : (jc) File not opened
;       ax = error code
;            2 = file not found
;            3 = path not found
;            4 = no more handles available
;            5 = access denied
; Registers:
;       ax, dx
;---------------------------------------------------------------
MACRO   DOS_OpenFile  fileName
        mov     ah, 3Dh         ;; Assign DOS function number
        mov     al, 02          ;; Open for read/write access
        mov     dx, OFFSET fileName  ;; Assign name address to ds:dx
        int     21h             ;; Call DOS
ENDM    DOS_OpenFile

;---------------------------------------------------------------
; (3Eh) DOS_CloseFile   Close a previously opened file
;---------------------------------------------------------------
; Input:
;       bx = file handle from DOS_CreateFile or DOS_OpenFile
; Output:
;       cf = 0 : (jnc) File closed
;
;       cf = 1 : (jc) File not closed
;       ax = error code
;            6 = bad handle or file was not open
; Registers:
;       ax
;---------------------------------------------------------------
MACRO   DOS_CloseFile
        mov     ah, 3Eh         ;; Assign DOS function number
        int     21h             ;; Call DOS
ENDM    DOS_CloseFile

;---------------------------------------------------------------
; (3Fh) DOS_ReadFile    Read from file or device
;---------------------------------------------------------------
; Input:
;       bx = file handle from DOS_CreateFile or DOS_OpenFile
;       cx = number of bytes requested to read
;       buffer = label of destination buffer in ds data segment
;       Note: buffer must be at least cx bytes long!
; Output:
;       cf = 0 : (jnc) Read was successful
;       ax = actual number of bytes read (0=at end of file)
;
;       cf = 1 : (jc) Read was not successful
;       ax = error code
;            5 = access denied
;            6 = bad handle or file was not open
; Registers:
;       ax, dx
;---------------------------------------------------------------
MACRO   DOS_ReadFile  buffer
        mov     ah, 3Fh         ;; Assign DOS function number
        mov     dx, OFFSET buffer  ;; Address buffer with ds:dx
        int     21h             ;; Call DOS
ENDM    DOS_ReadFile

;---------------------------------------------------------------
; (40h) DOS_WriteFile   Write to file or device
;---------------------------------------------------------------
; Input:
;       bx = file handle from DOS_CreateFile or DOS_OpenFile
;       cx = number of bytes requested to write
;       buffer = label of source buffer in ds data segment
; Output:
;       cf = 0 : (jnc) Write was successful
;       ax = actual number of bytes written (0=disk is full)
;
;       cf = 1 : (jc) Write was not successful
;       ax = error code
;            5 = access denied
;            6 = bad handle or file was not open
; Registers:
;       ax, dx
;---------------------------------------------------------------
MACRO   DOS_WriteFile  buffer
        mov     ah, 40h         ;; Assign DOS function number
        mov     dx, OFFSET buffer  ;; Address buffer with ds:dx
        int     21h             ;; Call DOS
ENDM    DOS_WriteFile

;---------------------------------------------------------------
; (42h) DOS_Seek        Change location for next read/write
;---------------------------------------------------------------
; Input:
;       bx = file handle from DOS_CreateFile or DOS_OpenFile
;       cx = high word of 32-bit byte offset 
;       dx = low word of 32-bit byte offset
; Output:
;       cf = 0 : (jnc) Seek was successful
;       dx = high word of 32-bit offset position after seek
;       ax = low word of 32-bit offset position after seek
;
;       cf = 1 : (jc) Seek was not successful
;       ax = error code
;            6 = bad handle or file was not open
; Registers:
;       ax
;---------------------------------------------------------------
MACRO   DOS_Seek
        mov     ah, 42h         ;; Assign DOS function number
        xor     al, al          ;; Seeks to absolute position in cx,dx
        int     21h             ;; Call DOS
ENDM    DOS_Seek

;---------------------------------------------------------------
; (47h) DOS_GetDir      Get name of current directory
;---------------------------------------------------------------
; Input:
;       string = address of 64-byte (minimum) variable
; Output:
;       directory name inserted into string in ASCIIZ format
; Registers:
;       ax, dl, si
;---------------------------------------------------------------
MACRO   DOS_GetDir  string
        mov     ah, 47h         ;; Assign DOS function number
        xor     dl, dl          ;; 0 specifies current drive
        mov     si, OFFSET string  ;; Address string with ds:si
        int     21h             ;; Call DOS
ENDM    DOS_GetDir

;---------------------------------------------------------------
; (4Ch) DOS_Terminate   End program
;---------------------------------------------------------------
; Input:
;       code = [label] or value to pass to DOS or parent process
; Output:
;       none
; Registers:
;       ax
;---------------------------------------------------------------
MACRO   DOS_Terminate  code
        mov     ah, 4Ch         ;; Assign DOS function number
        mov     al, code        ;; Assign return code
        int     21h             ;; Call DOS
ENDM    DOS_Terminate

%LIST
