%TITLE "Divide Fault Demonstration -- by Tom Swan"

        IDEAL

        MODEL   small
        STACK   256

cr      EQU     13              ; ASCII carriage return
lf      EQU     10              ; ASCII line feed


        DATASEG

exCode          DB      0
message1        DB      cr,lf,'Forcing a divide by zero fault...',0
message2        DB      cr,lf,'Program continued normally',cr,lf,0


        CODESEG

;-----  From STRIO.OBJ
        EXTRN   StrWrite:proc

Start:  
        mov     ax, @data               ; Initialize DS to address
        mov     ds, ax                  ;  of data segment
        mov     es, ax                  ; Make es = ds

        mov     di, offset message1     ; Address welcome message
        call    StrWrite

        mov     ax, 100h                ; Assign value to ax
        xor     bx, bx                  ; Zero divisor
        div     bx                      ; Force Divide-Fault Exception

Exit:
        mov     di, offset message2     ; Address "continued" message
        call    StrWrite                ; Display string

        mov     ah,04Ch                 ; DOS function: Exit program
        mov     al,[exCode]             ; Return exit code value
        int     21h                     ; Call DOS. Terminate program

        END     Start        ; End of program / entry point
