%TITLE "80286 and later-model Divide-Fault ISR -- by Tom Swan"

        IDEAL

        MODEL   tiny

cr      EQU     13
lf      EQU     10


        DATASEG

welcome DB      cr, lf, '80286/386 Divide-Fault Handler Installed'
        DB      cr, lf, 'Address = ', 0
string  DB      40 dup (?)


        CODESEG

        ORG     100h            ; Standard .COM start address (origin)

        EXTRN   StrWrite:proc, BinToAscHex:proc, NewLine:proc

Start:  
        jmp     Begin           ; Jump over resident ISR

%NEWPAGE
;---------------------------------------------------------------
; DivFault              Divide-Fault handler ISR
;---------------------------------------------------------------
; Input:
;       none  (called internally upon a DIV or IDIV fault)
; Output:
;       ax = 0 (al=8-bit quotient, ax=16-bit quotient)
;
;       Note: Program continues normally with the instruction
;       following the DIV or IDIV that caused the fault.
;
; Registers:
;       ax changed
;---------------------------------------------------------------
PROC    DivFault
        sti                     ; Enable CPU interrupts
        push    bp              ; Save current bp register
        mov     bp, sp          ; Address stack values with ss:bp
        push    si              ; Save other modified registers
        push    ds
        lds     si, [bp + 2]    ; Address DIV or IDIV with ds:si
        lodsw                   ; Get DIV plus second byte (in ah)
        and     ah, 0C0h        ; Isolate first two bits (MOD field)
        cmp     ah, 0C0h        ; Are bits = 1? (register based instr)
        je      @@10            ; Jump if yes--DIV is 2 bytes long
        add     [word bp + 2], 2  ; DIV is 4-bytes add 2 to offset
@@10:   add     [word bp + 2], 2  ; Add 2 (or 2 more) to offset
        xor     ax, ax          ; Set quotient to 0 (remainder also 0
                                ;  for 8-bit divide only)
        pop     ds              ; Restore saved registers
        pop     si
        pop     bp
        iret                    ; Return from interrupt
ENDP    DivFault

Begin:
        mov     ax, 2500h               ; Set new vector for Divide
        mov     dx, offset DivFault
        int     21h
        mov     di, offset welcome      ; Display welcoming message
        call    StrWrite
        mov     ax, cs                  ; Display segment value
        call    ShowAX
        mov     dl, ':'                 ; Display a colon (:)
        mov     ah, 2
        int     21h
        mov     ax, offset DivFault     ; Display offset value
        call    ShowAX
        call    NewLine

;-----  Terminate and stay resident, keeping only the code up to
;       the end of the new Divide-Fault ISR

Exit:
        mov     dx, offset Begin        ; New free mem address
        int     27h                     ; Terminate, stay resident

;-----  Subroutine to display AX in hexadecimal

PROC    ShowAX                          ; Show value in AX
        mov     cx, 4                   ; Minimum number of chars
        mov     di, offset string       ; Address of string variable
        call    BinToAscHex             ; Convert AX to hex
        call    StrWrite                ; Display hex string
        ret                             ; Return to caller
ENDP    ShowAX
        
        END     Start        ; End of program / entry point
