%TITLE "Disk-Error Handler -- by Tom Swan"

        IDEAL

        MODEL   small

        DATASEG

errString       DB      '** ERROR: ', 0

err00   DB      'Unknown cause', 0
err01   DB      'Bad function number', 0
err02   DB      'File not found', 0
err03   DB      'Path not found', 0
err04   DB      'Too many open files', 0
err05   DB      'Access denied', 0
err06   DB      'File handle invalid', 0
err07   DB      'Memory control blocks destroyed', 0
err08   DB      'Not enough memory for operation', 0
err09   DB      'Bad memory block address', 0
err0A   DB      'Bad environment', 0
err0B   DB      'Bad format', 0
err0C   DB      'Bad access code', 0
err0D   DB      'Bad data', 0
err0E   DB      'Unknown cause', 0
err0F   DB      'Bad disk drive letter', 0
err10   DB      'Removing current directory is not allowed', 0
err11   DB      'Device is not the same', 0
err12   DB      'No more files available', 0
err13   DB      'Disk is write-protected', 0
err14   DB      'Unknown unit', 0
err15   DB      'Disk drive is not ready', 0
err16   DB      'Unknown command', 0
err17   DB      'Data (CRC) error', 0
err18   DB      'Bad structure length', 0
err19   DB      'Seek error', 0
err1A   DB      'Unknown type of medium', 0
err1B   DB      'Sector not found', 0
err1C   DB      'Printer is out of paper', 0
err1D   DB      'Disk write error', 0
err1E   DB      'Disk read error', 0
err1F   DB      'General failure', 0

errors  DW      err00, err01, err02, err03, err04, err05, err06, err07
        DW      err08, err09, err0A, err0B, err0C, err0D, err0E, err0F
        DW      err10, err11, err12, err13, err14, err15, err16, err17
        DW      err18, err19, err1A, err1B, err1C, err1D, err1E, err1F

        CODESEG

;-----  From STRIO.OBJ
        EXTRN   NewLine:proc, StrWrite:proc

        PUBLIC  DiskErr

%NEWPAGE
;---------------------------------------------------------------
; DiskErr       Write disk error message to standard output
;---------------------------------------------------------------
; Input:
;       none (cf=1 following a DOS file operation)
; Output:
;       none (error message displayed)
; Registers:
;       ax, bp, bx, cx, dx, di, si changed
;---------------------------------------------------------------
PROC    DiskErr
        push    ds                      ; Save segment registers
        push    es                      ;  modified by DOS fn 59h
        mov     ah, 59h                 ; DOS Extended err fn num
        xor     bx, bx                  ; Must be zero
        int     21h                     ; Get extended error info
        pop     es                      ; Restore segment registers
        pop     ds

        cmp     ax, 1Fh                 ; Is ax > 1Fh?
        jbe     @@10                    ; Jump if ax <= 1Fh
        xor     ax, ax                  ; Use "Unknown Cause" message
@@10:
        shl     ax, 1                   ; Multiply ax by 2
        mov     bx, ax                  ; Copy ax to bx
        mov     di, [errors+bx]         ; Get address of string
        push    di                      ; Save di temporarily
        call    NewLine                 ; Start new display line
        mov     di, offset errString    ; Address first part of message
        call    StrWrite                ; Write ERROR message
        pop     di                      ; Restore address of message
        call    StrWrite                ; Write message to std out
        call    NewLine                 ; Start a new display line
        ret                             ; Return to caller
ENDP    DiskErr

        END                     ; End of module
