%TITLE "Date and Time Routines -- by Tom Swan"

        IDEAL

        MODEL   small


        DATASEG

;-----  Month names including dash separators.  No null at end.
;       Note: Bad month values display as '???'

months  DB      '-???-Jan-Feb-Mar-Apr-May-Jun-Jul-Aug-Sep-Oct-Nov-Dec-'


;-----  Time am and pm strings.  Must have nulls at ends.

amStr   DB      ' am', 0        ; Note space before am
pmStr   DB      ' pm', 0        ; And a space before pm, too


        CODESEG

;-----  From STRINGS.OBJ, BINASC.OBJ

        EXTRN   MoveLeft:proc, StrConcat:proc, BinToAscDec:proc

        PUBLIC  GetDate, GetTime, DateToStr, TimeToStr
        PUBLIC  GetDateStr, GetTimeStr

%NEWPAGE
;---------------------------------------------------------------
; TwoDigits     Insert 2-digit number into a string
;---------------------------------------------------------------
; Note:
;       Private subroutine for DateToStr and TimeToStr
; Input:
;       ah = 8-bit value
;       di = destination address
; Output:
;       2-digit number plus null terminator inserted at di
; Registers:
;       ah, al (indirectly), cx
;---------------------------------------------------------------
PROC    TwoDigits
        xor     ah, ah          ; Zero upper byte of ax
        mov     cx, 2           ; Request minimum 2 digits
        call    BinToAscDec     ; Convert ax to ASCII
        ret                     ; Return to caller
ENDP    TwoDigits
%NEWPAGE
;---------------------------------------------------------------
; GetDate       Get system date information
;---------------------------------------------------------------
; Input:
;       none
; Output:
;       al = weekday    (0-Sun, 1-Mon, ..., 6-Sat)
;       cx = year       (1980 to 2099)
;       dh = month      (1-Jan, 2-Feb, ..., 12-Dec)
;       dl = day        (1 to 31)
;       Note: al equals weekday only for DOS versions >= 1.1
; Registers:
;       ax, cx, dx
;---------------------------------------------------------------
PROC    GetDate
        mov     ah,02ah         ; DOS "Get Date" function number
        int     21h             ; Call DOS for date information
        ret                     ; Return to caller
ENDP    GetDate
%NEWPAGE
;---------------------------------------------------------------
; GetTime       Get system time information
;---------------------------------------------------------------
; Input:
;       none
; Output:
;       ch = hour (0 to 23)
;       cl = minutes (0 to 59)
;       dh = seconds (0 to 59)
;       dl = hundredths of seconds (0 to 99)
; Registers:
;       ah, cx, dx
;---------------------------------------------------------------
PROC    GetTime
        mov     ah,02ch         ; DOS "Get Time" function number
        int     21h             ; Call DOS for date information
        ret                     ; Return to caller
ENDP    GetTime
%NEWPAGE
;---------------------------------------------------------------
; DateToStr     Convert date information to 'dd-mmm-yyyy' string
;---------------------------------------------------------------
; Input:
;       al = weekday    (0-Sun, 1-Mon, ..., 6-Sat)
;       cx = year      *(Four- or two-digit year allowed)
;       dh = month      (1-Jan, 2-Feb, ..., 12-Dec)
;       dl = day        (1 to 31)
;       di = address of ASCIIZ string to hold result
;      *Note: dd-mmm-yyyy string must be at least 12 bytes long
;      *Note: dd-mmm-yy string must be at least 10 bytes long
;       Note: bad months shown as in 00-???-0000
; Output:
;       none (date string inserted at di)
; Registers:
;       ax, bx, cx, dx
;---------------------------------------------------------------
PROC    DateToStr
        push    di              ; Save modified registers
        push    si
        push    cx              ; Save year
        push    dx              ; Save month and day

        mov     al, dl          ; ax = day in 16 bits
        call    TwoDigits       ; Convert ax (day) to ASCII
        add     di, 2           ; Advance string pointer
        pop     dx              ; Restore month and day

        mov     si, offset months       ; Address month names with si
        xor     bx, bx          ; Preset bx index to 0
        cmp     dh, 12          ; Check for bad month range
        jg      @@10            ; Jump if dl (month) is > 12
        mov     bl, dh          ; Set bx to month in 16 bits
@@10:
        shl     bx, 1           ; bx <- bx * 4, indexing to
        shl     bx, 1           ;  month name or to '???' if bad
        mov     dx, 0           ; Set destination string index
        mov     cx, 5           ; Number of chars to copy
        call    MoveLeft        ; Copy month to destination
        add     di, cx          ; Advance string pointer

        pop     ax              ; Pop year into ax
        mov     cx, 2           ; Request at least 2 chars
        call    BinToAscDec     ; Convert ax (year) to string

        pop     si              ; Restore registers
        pop     di
        ret                     ; Return to caller
ENDP    DateToStr
%NEWPAGE
;---------------------------------------------------------------
; TimeToStr     Convert time information to 'hh:mm am/pm' string
;---------------------------------------------------------------
; Input:
;       ch = hour (0 to 23)
;       cl = minutes (0 to 59)
;       di = address of ASCIIZ string to hold result
;       Note: string must be at least 9 bytes long
; Output:
;       none (time string inserted at di)
; Registers:
;       ax, cx
;---------------------------------------------------------------
PROC    TimeToStr
        cmp     ch, 12          ; Is ch > 12?
        pushf                   ; Save result (flags) on stack
        jbe     @@10            ; If ch <= 12, jump
        sub     ch, 12          ;  else convert 24- to 12-hour time
@@10:
        push    di              ; Save string address (di) on stack
        push    cx              ; Save hour and minutes on stack
        mov     al, ch          ; Assign hour in ch to ah
        call    TwoDigits       ; Convert hour to ASCII
        add     di, 3           ; Advance di 3 chars (past null)
        mov     [byte ptr di-1], ':'    ; Insert colon over null
        pop     ax              ; Pop minutes into al
        call    TwoDigits       ; Convert minutes to ASCII
        pop     di              ; Restore di register
        popf                    ; Restore flags from previous cmp
        mov     si, offset amStr        ; Address amStr with si
        jbe     @@20                    ; Jump if hour <= 12
        mov     si, offset pmStr        ; Address pmStr with si
@@20:
        call    StrConcat       ; Add am or pm to time string
        ret                     ; Return to caller
ENDP    TimeToStr
%NEWPAGE
;---------------------------------------------------------------
; GetDateStr    Get current date as a string
;---------------------------------------------------------------
; Input:
;       di = address of ASCIIZ string to hold date string
;       Note: string must hold at least 00 chars + 0 terminator
; Output:
;       none (date string inserted at di)
; Registers:
;       none
;---------------------------------------------------------------
PROC    GetDateStr
        push    ax              ; Save registers modified
        push    bx              ;  by GetDate and DateToStr
        push    cx
        push    dx
        call    GetDate         ; Get system date
        call    DateToStr       ; Convert date info to string
        pop     dx              ; Restore registers
        pop     cx
        pop     bx
        pop     ax
        ret                     ; Return to caller
ENDP    GetDateStr
%NEWPAGE
;---------------------------------------------------------------
; GetTimeStr    Get current time as a string
;---------------------------------------------------------------
; Input:
;       di = address of ASCIIZ string to hold time string
;       Note: string must hold at least 00 chars + 0 terminator
; Output:
;       none (time string inserted at di)
; Registers:
;       none
;---------------------------------------------------------------
PROC    GetTimeStr
        push    ax              ; Save registers modified
        push    cx              ;  by GetTime procedure
        push    dx
        call    GetTime         ; Get system time
        call    TimeToStr       ; Convert time info to string
        pop     dx              ; Restore registers
        pop     cx
        pop     ax
        ret                     ; Return to caller
ENDP    GetTimeStr


        END                     ; End of module

