// Object-oriented C++ and assembly language -- by Tom Swan

#include <iostream.h>

class TBuffer {

// Constructor and destructor
public:
  TBuffer(char c, int bs);
 ~TBuffer();

// Member functions
public:
  void SetFillChar(char c)
    { fillChar = c; }
  char GetFillChar()
    { return fillChar; }
  int GetFillSize()
    { return fillSize; }
  void FillBuffer();
  void ShowBuffer(const char *s);

// Private data members
private:
  char fillChar;      // Character to insert in buffer
  int  fillSize;      // Size of buffer in bytes
  char far *buffer;   // Pointer to buffer
};

// External asm module function declaration
extern "C" void ASMFillBuffer(TBuffer far &bo, char far *buffer);

// External cpp module function declarations
extern "C" char CPPGetFillChar(TBuffer &bo);
extern "C" int CPPGetFillSize(TBuffer &bo);

int main()
{
  TBuffer b1('@', 10);  // Construct objects
  TBuffer b2('#', 15);
  TBuffer b3('*', 25);  

  b1.ShowBuffer("b1");  // Display object buffers
  b2.ShowBuffer("b2");
  b3.ShowBuffer("b3");

  b1.SetFillChar('1');  // Set fill chars and refill buffer
  b1.FillBuffer();
  b2.SetFillChar('2');
  b2.FillBuffer();
  b3.SetFillChar('3');
  b3.FillBuffer();

  b1.ShowBuffer("b1");  // Display object buffers
  b2.ShowBuffer("b2");
  b3.ShowBuffer("b3");

  return 0;             // End program
}

// Implement TBuffer constructor
TBuffer::TBuffer(char c, int bs)
{
  fillChar = c;                 // Save fill character
  fillSize = bs;                // Save buffer size
  buffer = 0;                   // Initialize buffer pointer
  if (fillSize <= 0) return;    // Exit if size is <= zero
  buffer = new char[fillSize];  // Allocate memory for buffer
  FillBuffer();                 // Fill buffer with characters
}

// Implement TBuffer destructor
TBuffer::~TBuffer()
{
  delete buffer;    // Dispose of allocated memory
}

// Implement fill-buffer member function
// Calls external assembly language function
void TBuffer::FillBuffer()
{
  ASMFillBuffer(*this, buffer);  // Call function in asm module

/* C++ equivalent code for above function call
  if (buffer == 0) return;
  for (int i = 0; i < GetFillSize(); i++)
    buffer[i] = GetFillChar();
*/
}

// Implement show-buffer member function
void TBuffer::ShowBuffer(const char *s)
{
  cout << endl;
  cout << "Buffer  : " << s;
  cout << ", size = " << GetFillSize() << " byte(s)" << endl;
  cout << "Contents: ";
  for (int i = 0; i < GetFillSize(); i++)
    cout << buffer[i];
  cout << endl;
}

// Return fill character for object bo
// Called by external asm function
extern "C" 
char CPPGetFillChar(TBuffer &bo)
{
  return bo.GetFillChar();  
}

// Return buffer size for object bo
// Called by external asm function
extern "C" 
int CPPGetFillSize(TBuffer &bo)
{
  return bo.GetFillSize();
}
