%TITLE "Copy String External C function -- by Tom Swan"

        IDEAL

        MODEL   small

        CODESEG

        PUBLIC  _copystring

PROC    _copystring      NEAR

        ARG source:DWord, destination:DWord, sourcelen:Word

        push    bp                      ; Save bp
        mov     bp, sp                  ; Address params with bp
        mov     cx, [sourcelen]         ; Load length into cx
        jcxz    @@99                    ; Exit if cx = 0
        push    ds                      ; Save ds on stack
        les     di, [destination]       ; Address dest with es:di
        lds     si, [source]            ; Address source with ds:si
        cld                             ; Auto-increment si, di
        rep     movsb                   ; Copy source chars to dest
        pop     ds                      ; Restore ds
@@99:
        pop     bp              ; Restore bp
        ret                     ; Return to caller
ENDP    _copystring

        END                     ; End of module



