%TITLE "Convert binary, hex, decimals -- by Tom Swan"

        IDEAL

        MODEL   small
        STACK   256

;-----  Equates

EOS     EQU     0               ; End of string
cr      EQU     13              ; ASCII carriage return
lf      EQU     10              ; ASCII line feed
maxLen  EQU     40              ; Maximum entry string length


        DATASEG

exCode          db      0       ; DOS error code

welcome  db     cr,lf,'Convert binary, hexadecimal, decimal values'
         db     cr,lf,'(c) 1995 by Tom Swan',cr,lf
         db     cr,lf,'Press Enter to quit.',cr,lf,EOS
prompt   db     cr,lf,lf,'Value to convert? ', EOS
error    db     cr,lf,'**ERROR: Illegal character in string',EOS
binary   db     cr,lf,'Binary ............. : ',EOS
hex      db     cr,lf,'Hexadecimal ........ : ',EOS
decimal  db     cr,lf,'Unsigned decimal ... : ',EOS
sdecimal db     cr,lf,'Signed decimal ..... : ',EOS

value    dw     ?                       ; Result of AscToBin
response db     maxLen+1 DUP (?)        ; String for user response


        CODESEG

;-----  From STRINGS.OBJ & STRIO.OBJ

        EXTRN   StrLength:proc, StrRead:proc
        EXTRN   StrWrite:proc, NewLine:proc

;-----  From BINASC.OBJ

        EXTRN   BinToAscHex:proc, SBinToAscDec:proc, BinToAscDec:proc
        EXTRN   BinToAscBin:proc, AscToBin:proc

Start:  
        mov     ax, @data               ; Initialize DS to address
        mov     ds, ax                  ;  of data segment
        mov     es, ax                  ; Make es = ds

        mov     di, OFFSET welcome      ; Display welcome message
        call    StrWrite

;-----  Prompt for value to convert

Again:
        mov     di, OFFSET prompt       ; Display prompt string
        call    StrWrite
        mov     di, OFFSET response     ; Get user response
        mov     cx, maxLen              ; Maximum string length
        call    StrRead
        call    NewLine                 ; Start new display line
        call    StrLength               ; Did user press Enter?
        jcxz    Exit                    ; Exit if yes (cx=0)

;-----  Convert entered chars to binary

        call    AscToBin                ; Convert string to ax
        mov     [value], ax             ; Save result in variable
        jnc     Continue                ; Jump if cf is 0--no error
        mov     di, OFFSET error        ; Else display error message
        call    StrWrite
        jmp     Again                   ; Let user try again

;-----  Convert binary value to various string number formats

Continue:
        mov     di, OFFSET binary       ; Display binary label
        call    StrWrite
        mov     ax, [value]             ; Get value to convert
        mov     cx, 16                  ; Minimum number of digits
        mov     di, OFFSET response     ; Use same string for result
        call    BinToAscBin             ; Convert to binary digits
        call    StrWrite                ; Display result
        
        mov     di, OFFSET hex          ; Display hex label
        call    StrWrite
        mov     ax, [value]             ; Get value to convert
        mov     cx, 4                   ; Minimum number of digits
        mov     di, OFFSET response     ; Use same string for result
        call    BinToAscHex             ; Convert to hex digits
        call    StrWrite                ; Display result

        mov     di, OFFSET decimal      ; Display decimal label
        call    StrWrite
        mov     ax, [value]             ; Get value to convert
        mov     cx, 1                   ; Minimum number of digits
        mov     di, OFFSET response     ; Use same string for result
        call    BinToAscDec             ; Convert to decimal digits
        call    StrWrite                ; Display result

        mov     di, OFFSET sdecimal     ; Display signed decimal label
        call    StrWrite
        mov     ax, [value]             ; Get value to convert
        mov     cx, 1                   ; Minimum number of digits
        mov     di, OFFSET response     ; Use same string for result
        call    SBinToAscDec            ; Convert to signed decimal
        call    StrWrite                ; Display result
        jmp     Again                   ; Repeat until done
Exit:
        mov     ah, 04Ch                ; DOS function: Exit program
        mov     al, [exCode]            ; Return exit code value
        int     21h                     ; Call DOS. Terminate program

        END     Start        ; End of program / entry point
