%TITLE "Perform Warm or Cold Reboot -- by Tom Swan"

        IDEAL
        MODEL   small
        STACK   256

WarmBoot        EQU     1234h           ; Skips power-on system tests (POST)
ColdBoot        EQU     1234d           ; Other value may work

BIOSDataLoc     EQU     0040h           ; Segment address of BIOS data
ResetFlagLoc    EQU     0072h           ; Offset to ResetFlag in BIOS data


;-----  Tell assembler where the ResetFlag word is located

SEGMENT BIOSData at BIOSDataLoc
        ORG     ResetFlagLoc
LABEL   ResetFlag Word
ENDS

        CODESEG

Start:  
        mov     ax, BIOSDataLoc         ; Address BIOSData segment
        mov     ds,ax                   ;  with ds

ASSUME  DS:BIOSData

        mov     [ResetFlag],ColdBoot    ; Set ResetFlag

        END     Start        ; End of program / entry point
