%TITLE "Display Character/Attribute Ref -- by Tom Swan"

        IDEAL

        MODEL   small
        STACK   256


cr              EQU     13      ; ASCII carriage return
lf              EQU     10      ; ASCII line feed
ChartRow        EQU     7       ; Row for attribute chart


        DATASEG

exCode          DB      0
welcome         DB      'Character attributes -- by Tom Swan',cr,lf
                DB      'Rows=background, Columns=foreground',cr,lf
                DB      'First char is dim, second char is bright',0
template        DB      '    00  01  02  03  04  05  06  07',cr,lf
                DB      '00',cr,lf,'01',cr,lf,'02',cr,lf,'03',cr,lf
                DB      '04',cr,lf,'05',cr,lf,'06',cr,lf,'07',0
blinkString     DB      'This line should be blinking.', 0


        CODESEG

;-----  From STRINGS.OBJ, STRIO.OBJ
        EXTRN   StrLength:proc, StrWrite:proc

;-----  From SCREEN.OBJ
        EXTRN   ScInit:proc, ScGotoXY:proc, ScClrRect:proc
        EXTRN   ScPokeChar:proc, ScSetBack:proc, ScSetFore:proc
        EXTRN   ScPokeStr:proc, ScDim:proc, ScBright:proc
        EXTRN   ScBlink:proc, ScNoBlink:proc

Start:  
        mov     ax, @data               ; Initialize DS to address
        mov     ds, ax                  ;  of data segment
        mov     es, ax                  ; Make es = ds

        call    ScInit                  ; Initialize SCREEN package
        call    Setup                   ; Set up display
        call    Attributes              ; Display attribute chart
        call    Blinking                ; Display blinking chars

        mov     dh, 23                  ; Position cursor on next to 
        mov     dl, 0                   ;  last display line before
        call    ScGotoXY                ;  ending program.

Exit:
        mov     ah, 04Ch                ; DOS function: Exit program
        mov     al, [exCode]            ; Return exit code value
        int     21h                     ; Call DOS. Terminate program


;-----  SETUP: Initialize display

PROC    SetUp
        mov     ch, 0                   ; Clear screen
        mov     cl, 0
        mov     dh, 24
        mov     dl, 79
        call    ScClrRect
        mov     dh, 1                   ; Display welcome message
        mov     dl, 0
        call    ScGotoXY
        mov     di, offset welcome
        call    StrWrite
        mov     dh, ChartRow            ; Display chart template
        mov     dl, 0
        call    ScGotoXY
        mov     di, offset template
        call    StrWrite
        ret
ENDP    Setup


;-----  ATTRIBUTES: Display attribute chart

UDATASEG
row             DB      ?       ; Uninitialized variables
column          DB      ?
background      DB      ?
foreground      DB      ?

CODESEG
PROC    Attributes
        mov     [row], ChartRow         ; Initialize row
        mov     [background], 0         ; Initialize background
@@10:
        inc     [row]                   ; Next row
        mov     al, [background]        ; Set background attribute
        call    ScSetBack
        mov     [column], 1             ; Initialize column
        mov     [foreground], 0         ; Initialize foreground
@@20:
        add     [column], 3             ; Move to next column
        mov     al, [foreground]        ; Set foreground attribute
        call    ScSetFore
        call    ScDim                   ; First char is dim
        call    OneChar
        inc     [column]
        call    ScBright                ; Next char is bright
        call    OneChar
        inc     [foreground]            ; Repeat for all foregrounds
        cmp     [foreground], 7
        jbe     @@20

        inc     [background]            ; Repeat for all backgrounds
        cmp     [background], 7
        jbe     @@10

        ret
ENDP    Attributes


;-----  ONECHAR: Local subroutine for ATTRIBUTES

PROC    OneChar
        mov     dh, [row]               ; Get row number
        mov     dl, [column]            ; Get column number
        mov     al, 'A'                 ; Character to display
        call    ScPokeChar              ; Display char
        ret
ENDP    OneChar


;-----  BLINKING: Display blinking/non-blinking text

PROC    Blinking
        mov     al, 0
        call    ScSetBack               ; Set background to black
        mov     al, 7
        call    ScSetFore               ; Set foreground to white
        call    ScBright                ; Make it whiter than white
        call    ScBlink                 ; Turn on blinking
        mov     di, offset blinkString  ; Address string with di
        call    StrLength               ; Set cx to string length
        mov     dh, 19                  ; Assign location to dh, dl
        mov     dl, 0
        mov     si, offset blinkString  ; Address string with si
        call    ScPokeStr               ; Display the string
        call    ScNoBlink               ; Turn off blinking
        ret
ENDP    Blinking

        END     Start        ; End of program / entry point
