%TITLE "Fill C Strings Demonstration -- by Tom Swan"

        IDEAL

        MODEL   small

        CODESEG

        PUBLIC  _fillstring

;---------------------------------------------------------------
; void fillstring( unsigned char far * thestring,
;    int stringlength, char fillchar )
;---------------------------------------------------------------
PROC    _fillstring      NEAR

        ARG thestring:Dword, stringlength:Word, fillchar:Byte

        push    bp                      ; Save old bp pointer
        mov     bp, sp                  ; Address parameters
        mov     cx, [stringlength]      ; Assign string len to cx
        jcxz    @@99                    ; Exit if length = 0
        push    di                      ; Save di
        les     di, [thestring]         ; Address string with es:di
        mov     al, [fillchar]          ; Assign fill char to al
        repnz   stosb                   ; Store characters in string
        pop     di                      ; Restore saved di
@@99:
        pop     bp                      ; Restore saved bp
        ret                             ; Return to caller
ENDP    _fillstring

        END                     ; End of module
