%TITLE "Test CapsLock Key -- by Tom Swan"

        IDEAL
        MODEL   small
        STACK   256

BIOSDataLoc     EQU     0040h  ; Segment address of BIOS data
KbFlagLoc       EQU     017h   ; Offset to keyboard flag
CapsLockFlag    EQU     040h   ; Capslock key bit

SEGMENT BIOSData at BIOSDataLoc
        ORG     KbFlagLoc
LABEL   KbFlag  Byte
ENDS    BIOSData

        DATASEG

CapsString      db      'CapsLock is: ', ,0
CapsOn          db      'ON', 0
CapsOff         db      'OFF', 0

        CODESEG

        EXTRN   StrWrite:proc

ASSUME  DS:BIOSData

Start:  
        mov     ax, BIOSDataLoc         ; Address BIOSData segment
        mov     es, ax                  ;  with es
        ASSUME  es:BIOSData             ; Tell tasm where es points
        mov     bl, [es:KbFlag]         ; Load keyboard flag into bl
        mov     ax, @data               ; Initialize ds and es
        mov     ds, ax                  ;  to default data segment
        mov     es, ax
        ASSUME  es:@data, es:@data      ; Tell tasm where es, ds point
        mov     di, offset CapsString   ; Address string with di
        call    StrWrite                ; Display string
        mov     di, offset CapsOn       ; Address "ON" with di
        test    bl, 040h                ; Test capslock flag bit
        jnz     @@10                    ; Jump if bit <> 0
        mov     di, offset CapsOff      ; Else address "OFF" with di
@@10:
        call    StrWrite                ; Display "ON" or "OFF"
        mov     ax, 04C00h              ; DOS function: Exit program
        int     21h                     ; Call DOS. Terminate program

        END     Start           ; End of program / entry point
