%TITLE "Box char demonstration -- by Tom Swan"

        IDEAL

        MODEL   small
        STACK   256

cr              EQU     13      ; ASCII carriage return
lf              EQU     10      ; ASCII line feed
Fn10            EQU     100     ; GetCh value for F10
LowIndex        EQU     152     ; GetCh value for Alt-1
HighIndex       EQU     161     ; GetCh value for Alt-0

        DATASEG

message db      cr, lf, 'Sample Character Table Translation'
        db      cr, lf, 'Press Alt-1 to Alt-0 to display characters'
        db      cr, lf, 'Press F10 to end', cr, lf, lf, 0

ctable  db      179, 180, 191, 192, 193, 194, 195, 196, 217, 218
 
        CODESEG

        EXTRN   StrWrite:proc, GetCh:proc
        
Start:  
        mov     ax, @data               ; Initialize DS to address
        mov     ds, ax                  ;  of data segment
        mov     es, ax                  ; Make es = ds

        mov     di, offset message      ; Display instructions
        call    StrWrite
@@10:
        call    GetCh                   ; Get key press
        jnz     @@10                    ; Repeat if not function key
        cmp     al, Fn10                ; Check for F10
        je      Exit                    ; Exit if F10 pressed
        cmp     al, LowIndex            ; Verify that al is within
        jb      @@10                    ;  range of LowIndex to 
        cmp     al, HighIndex           ;  HighIndex
        ja      @@10
        sub     al, LowIndex            ; Convert al to 0..n
        mov     bx, offset ctable       ; Address ctable with ds:bx
        xlat                            ; Translate al from ctable
        mov     dl, al                  ; Move new char in al to dl
        mov     ah, 2                   ; DOS "display char" function
        int     21h                     ; Call DOS to display char
        jmp     @@10                    ; Repeat until done
Exit:
        mov     ax,04C00h               ; DOS function: Exit program
        int     21h                     ; Call DOS. Terminate program

        END     Start        ; End of program / entry point
