%TITLE "Bound Test--80286/386 only! -- by Tom Swan"

        P286N
        IDEAL

        MODEL   small
        STACK   256

        DATASEG

exCode          DB      0

errorMsg        db      '**Error: array index out of bounds', 0
normalMsg       db      'Program ending with no errors', 0

lowRange        DW      100     ; Lowest index range
highRange       DW      199     ; Highest index range
oldSeg          DW      ?       ; Saves interrupt 5 segment
oldOfs          DW      ?       ; Saves interrupt 5 offset

        CODESEG

;-----  From    STRIO.OBJ
        EXTRN   StrWrite:proc, NewLine:proc

Start:  
        mov     ax, @data               ; Initialize DS to address
        mov     ds, ax                  ;  of data segment
        mov     es, ax                  ; Make es = ds

        push    es                      ; Save es
        mov     ax, 03505h              ; Get interrupt 5 vector 
        int     21h                     ; Call DOS
        mov     [oldSeg], es            ; Save segment address
        mov     [oldOfs], bx            ; Save offset address
        pop     es                      ; Restore es

        push    ds                      ; Save ds
        mov     ax, 02505h              ; Set new interrupt 5 vector
        mov     dx, offset Int5ISR      ; To this offset address
        push    cs                      ; And to this code
        pop     ds                      ;  segment address
        int     21h                     ; Call DOS
        pop     ds                      ; Restore ds

        mov     bx, 2                   ; Assign index value to bx 
        bound   bx, [lowRange]          ; Test index range

        mov     di, offset normalMsg    ; Display "no errors"
        call    StrWrite                ;  message
        call    NewLine

Exit:
        push    ds                      ; Save ds on stack
        mov     ax, 02505h              ; Set interrupt 5 vector
        mov     dx, [oldOfs]            ; To this offset and
        mov     ds, [oldSeg]            ; This segment
        int     21h                     ; Call DOS
        pop     ds                      ; Restore ds

        mov     ah, 04Ch                ; DOS function: Exit program
        mov     al, [exCode]            ; Return exit code value
        int     21h                     ; Call DOS. Terminate program

;-----  Interrupt 5 service routine: Abort program

PROC    Int5ISR
        mov     ax, @data               ; Reset ds and es just
        mov     ds, ax                  ; to be safe
        mov     es, ax
        mov     di, offset errorMsg     ; Address error message
        call    StrWrite                ; Display message
        call    NewLine
        jmp     Exit                    ; Exit program
ENDP    Int5ISR

        END     Start        ; End of program / entry point
