%TITLE "External function for a C++ class object -- by Tom Swan"

        IDEAL
        MODEL   small

;----- Code segment

        CODESEG

        EXTRN  _CPPGetFillChar:PROC  ; Function in C++ module
        EXTRN  _CPPGetFillSize:PROC  ; Function in C++ module
        PUBLIC _ASMFillBuffer        ; Function in asm module

;---------------------------------------------------------------
; void ASMFillBuffer(TBuffer far &bo, char far *buffer);
;---------------------------------------------------------------
PROC    _ASMFillBuffer    NEAR

        ARG bo_offset:DWORD, buffer_offset:DWORD

        push    bp              ; Save caller's bp
        mov     bp, sp          ; Set up for addressing arguments
        push    di              ; Save di if used for register vars

        les     di, [bo_offset] ; Get bo object address into es:di
        push    es              ; Push bo object address segment
        push    di              ; Push bo object address offset
        call    _CPPGetFillChar ; Call C++ function, pass object arg
        add     sp, 4           ; Adjust stack pointer to delete arg
        push    ax              ; Save char result in al on stack

        les     di, [bo_offset] ; Get bo object address into es:di
        push    es              ; Push bo object address segment
        push    di              ; Push bo object address offset
        call    _CPPGetFillSize ; Call C++ function, pass object arg
        add     sp, 4           ; Adjust stack pointer to delete arg
        mov     cx, ax          ; Copy int result in ax to cx
        les     di, [buffer_offset] ; Get buffer address into es:di
        pop     ax              ; Retrieve fill character from stack

; al = fill character
; cx = buffer size
; es:di = buffer address

        jcxz    @@99            ; Do nothing if count is zero
        cld                     ; Set fill direction to forward
        rep     stosb           ; Fill buffer: al -> es:di on cx
@@99:
        pop     di              ; Restore di
        pop     bp              ; Restore caller's bp
        ret                     ; Return to caller
ENDP    _ASMFillBuffer

        END                     ; End of module
