%TITLE "C++ Arguments Part 2 -- by Tom Swan"

        IDEAL
        MODEL   small

;----- Equates

cr      EQU     13      ; Carriage return
lf      EQU     10      ; Line feed

;----- Code segment

        CODESEG

        EXTRN  _CPPFunction:PROC  ; Function in C++ module
        PUBLIC _ASMFunction       ; Function in asm module

;---------------------------------------------------------------
; void ASMFunction(char c, int k);
;---------------------------------------------------------------
PROC    _ASMFunction C c_arg:byte, k_arg:word

        mov     cx, [k_arg]     ; Get argument k
        jcxz    @@99            ; Exit if k == 0
@@10:
        mov     ah, 2           ; Select DOS output function 2
        mov     dl, [c_arg]     ; Get character to display
        int     21h             ; Call DOS to output character
        loop    @@10            ; Loop on cx
        mov     dl, cr          ; Output carriage return
        int     21h
        mov     dl, lf          ; Output line feed
        int     21h
@@99:
        mov     ax, 30          ; Push count argument 
        push    ax              ;  onto stack
        mov     al, 'z'         ; Push character argument
        push    ax              ;  onto stack
        call    _CPPFunction    ; Call C++ function & pass args
        add     sp, 4           ; Adjust stack on return

        ret                     ; Return to caller
ENDP    _ASMFunction

        END                     ; End of module
