%TITLE "C++ and Assembly Language Arguments -- by Tom Swan"

        IDEAL
        MODEL   small

;----- Equates

cr      EQU     13      ; Carriage return
lf      EQU     10      ; Line feed

;----- Code segment

        CODESEG

        EXTRN  _CPPFunction:PROC  ; Function in C++ module
        PUBLIC _ASMFunction       ; Function in asm module

;---------------------------------------------------------------
; void ASMFunction(char c, int k);
;---------------------------------------------------------------
PROC    _ASMFunction    NEAR

        ARG c_offset:byte, k_offset:word

        push    bp              ; Save caller's bp
        mov     bp, sp          ; Set up for addressing arguments
        mov     cx, [k_offset]  ; Get loop count (k)
        jcxz    @@99            ; Exit if k == 0
@@10:
        mov     ah, 2           ; Select DOS output function 2
        mov     dl, [c_offset]  ; Get character (c) to display
        int     21h             ; Call DOS to output character
        loop    @@10            ; Loop on cx
        mov     dl, cr          ; Output carriage return
        int     21h
        mov     dl, lf          ; Output line feed
        int     21h
@@99:
        mov     ax, 30          ; Push count argument 
        push    ax              ;  onto stack
        mov     al, 'z'         ; Push character argument
        push    ax              ;  onto stack
        call    _CPPFunction    ; Call C++ function & pass args
        add     sp, 4           ; Adjust stack on return

        pop     bp              ; Restore caller's bp
        ret                     ; Return to caller
ENDP    _ASMFunction

        END                     ; End of module
