%TITLE "Sum of two hex values -- by Tom Swan"

        IDEAL

        MODEL   small
        STACK   256

        DATASEG

exCode          DB      0
prompt1         DB      'Enter value 1: ', 0
prompt2         DB      'Enter value 2: ', 0
string          DB      20 DUP (?)

        CODESEG

        EXTRN   StrLength:proc
        EXTRN   StrWrite:proc, StrRead:proc, NewLine:proc
        EXTRN   AscToBin:proc, BinToAscHex:proc

Start:  
        mov     ax, @data               ; Initialize DS to address
        mov     ds, ax                  ;  of data segment
        mov     es, ax                  ; Make es=ds

        mov     di, offset prompt1      ; Address prompt #1
        call    GetValue                ; Prompt for input
        push    ax                      ; Save first value
        mov     di, offset prompt2      ; Address prompt #2
        call    GetValue                ; Prompt for input
        pop     bx                      ; Get first value
        add     ax, bx                  ; ax <- sum of values
        mov     cx, 4                   ; Request 4 digits
        mov     di, offset string       ; Address string
        call    BinToAscHex             ; Convert ax to string
        call    StrWrite                ; Display answer
Exit:
        mov     ah, 04Ch                ; DOS function: Exit program
        mov     al, [exCode]            ; Return exit code value
        int     21h                     ; Call DOS.  Terminate program

; GetValue: di=address of prompt; output: ax=value entered in hex               
PROC    GetValue
        call    StrWrite
        mov     di, offset string
        mov     cl, 4
        call    StrRead
        call    NewLine
        call    StrLength
        mov     bx, cx
        mov     [word bx + di], 'h'
        call    AscToBin
        ret
ENDP    GetValue

        END     Start           ; End of program / entry point
