{                             TIMELIB.CH
                              CHESS 4.0
            Copyright (c) 1985, 87 by Borland International, Inc.

  This module implements the time keeping routines.

}
var   RecPack :  Registers;

procedure GetTime(var Hour,Minute,Second,Sec100 : integer);
{ gets the time from DOS }
begin
  RecPack.AX := $2C00;
  Intr($21, RecPack);
  Hour := Hi(RecPack.CX);
  Minute := Lo(RecPack.CX);
  Second := Hi(RecPack.DX);
  Sec100 := Lo(RecPack.DX);
end;

{ The Clock procedures provides a module for measuring Time.
  Think of the module as a Stop watch. InitTime resets a
  Clock completely. StartTime starts the Clock Running,
  StopTime stops it again, and TotalTime then contains the
  elapsed Time in seconds. You can use StartTime and StopTime
  again and have the elapsed Time added to the TotalTime, and
  you can use StopTime to get an intervening Time without
  stoping the Clock itself }

type
  ClockType = record
                Hour,Minute,Second,Sec100 : integer;
                TotalHours,TotMin,TotalSecs,Tots100 : integer;
                Number :    integer;
                TotalTime : real;
              end;

procedure InitTime(var Clock : ClockType);
{ Initializes a Clock }
begin
  with Clock do
    FillChar(Clock, SizeOf(Clock), chr(0));
end; { InitTime }

procedure StartTime(var Clock : ClockType);
{ Start a Clock }
begin
   with Clock do
     GetTime(Hour,Minute,Second,Sec100);
end;

procedure StopTime(var Clock : ClockType);
{ Add the elapsed Time to the Clock, but
  let the Clock Continue Running }
var   Hour1,Min1,Sec1,S100 : integer;
begin
  GetTime(Hour1,Min1,Sec1,S100);
  with Clock do
  begin
    if Hour1 < Hour then
      Inc(Hour1, 24);
    Inc(TotalHours, (Hour1 - Hour));
    Inc(TotMin, (Min1 - Minute));
    Inc(TotalSecs, (Sec1 - Second));
    Tots100 := Tots100 + (S100 - Sec100);
    Number := Number + 1;
    TotalTime := TotalTime + (S100 - Sec100) * 0.01 + (Sec1 - Second) +
                 (Min1 - Minute) * 60.0 + (Hour1 - Hour) * 3600.0;
    Hour := Hour1;
    Minute := Min1;
    Second := Sec1;
    Sec100 := S100;
   end;
end;
