{                             TALK.CH
                              CHESS 4.0
            Copyright (c) 1985, 87 by Borland International, Inc.

  This module initializes the game and communicates w/user.

}
var
  FirstCall : boolean;

procedure Talk;
{ Main routine.  This procedure manages all tasks. }
const
  Pieces : array[0..7] of PieceType = ( Rook, Knight, Bishop, Queen,
                                        King,Bishop, Knight, Rook );
var
  InLibrary : boolean;
  { true if program is in the opening library }

procedure InsertPiece(p : PieceType;
                      c : ColorType;
                     Sq : SquareType);
begin
  with Board[Sq] do
  begin
    Piece := p;
    Color := c;
  end;
end; { InsertPiece }

procedure ResetGame(var FirstCall : boolean);
{ Initiates a new game }
var   i : 0..7;
begin
   ClearBoard;                          { Reset Board }
   for i := 0 to 7 do                   { Setup Start position }
   begin
     InsertPiece(Pieces[i],White, i);
     InsertPiece(Pawn,White, i + $10);
     InsertPiece(Pawn,Black, i + $60);
     InsertPiece(Pieces[i],Black, i + $70);
   end;
   CalcPieceTab;   { Calculate PieceTab }
   Player := White;
   ColorToPlay(Player);
   Opponent := Black;
   Turned := false;   { Print Screen picture }
   SetBorder;
   SetUpScreen(FirstCall);
   PrintBoard;
end; { ResetGame }

var
  OpCount :  -1..61;            { Opening library }
  LibNo   : integer;

procedure ResetOpening;
{ Read Library file from disk }
const
  LibFileName = 'OPENING.LIB';    { note: can edit and include a path }
var
  LibFile : file of LibType;
  ch      : char;
begin
   Openings[0] := 0;
   ClrScr;
   Writeln('Looking for opening library...');
   Assign(LibFile, LibFileName);
   {$I-}
   Reset(LibFile);
   {$I+}
   if IOresult = 0 then
   begin
     Read(LibFile,Openings);
     Close(LibFile);
     Openings[0] := $FF;
   end
   else
   begin
     Writeln;
     Writeln(^G, 'Cannot find the library of opening moves.   Copy');
     Writeln(LibFileName, ' to the current directory if you want');
     Writeln('the chess program to use traditional openings.');
     Writeln;
     Write('Type <ESC> to quit, any other key to continue...');
     GetKey(ch);
     if (ch in [^[, ^C]) and not KeyPressed then Abort
     else { clear keyboard buffer }
       while KeyPressed do
         GetKey(ch);
   end;   { else }
end; { ResetOpening }

const UnPlayMark = $3F;

procedure NextLibNo(Skip : boolean);
{ Sets LibNo to the Next Move in the block.
  Unplayable moves are skipped if skip is set }

var
  n : integer;

procedure FirstLibNo;
{ Sets LibNo to the First Move in the block }

procedure PreviousLibNo;
{ Sets LibNo to the previous Move in the block }
var   n : integer;
begin
  n := 0;
  repeat
    LibNo := LibNo - 1;
    if Openings[LibNo] >= 128 then n := n + 1;
    if (Openings[LibNo] and 64) <> 0 then n := n - 1;
  until n = 0;
end; { PreviousLibNo }

begin { FirstLibNo }
  while (Openings[LibNo - 1] and 64) = 0 do
    PreviousLibNo;
end; { FirstLibNo }

begin
  if Openings[LibNo] >= 128 then FirstLibNo
  else
  begin
    n := 0;
    repeat
      if (Openings[LibNo] and 64) <> 0 then n := n + 1;
      if Openings[LibNo] >= 128 then n := n - 1;
        LibNo := LibNo + 1;
    until n = 0;
    if Skip and (Openings[LibNo] = UnPlayMark) then
      FirstLibNo;
  end;
end; { NextLibNo }

procedure CalcLibNo;
{ Sets LibNo to the block corresponding to the position }

var
  LibDepth : DepthType;
  Found    : boolean;

   procedure FindNode;
   { Find the node corresponding to the correct block }
   begin
      LibNo := LibNo + 1;
      if Depth > LibDepth then
      begin
         Found := true;
         Exit;
      end;
      OpCount := -1;
      InitMovGen;
      repeat
         OpCount := OpCount + 1;
         MovGen;
      until (Next.MovPiece = Empty) or EqMove(Next,MovTab[Depth]);
      if Next.MovPiece <> Empty then
      begin
         while ((Openings[LibNo] and 63) <> OpCount) and
                (Openings[LibNo] < 128) do
            NextLibNo(False);
         if (Openings[LibNo] and 127) = 64 + OpCount then
         begin
            MakeMove(MovTab[Depth]);
            FindNode;
            TakeBackMove(MovTab[Depth - 1]);
         end;
      end;
   end; { FindNode }

begin { CalcLibNo }
   LibNo := 0;
   if MoveNo < UseLib then
   begin
      LibDepth := Depth;
      while MovTab[Depth].MovPiece <> Empty do
         TakeBackMove(MovTab[Depth]);
      Found := false;
      if MovTab[Depth].Content = King then
      begin
         Depth := Depth + 1;
         FindNode;
         Depth := Depth - 1;
      end;
      while Depth < LibDepth do
         MakeMove(MovTab[Depth + 1]);
      if Found then
         UseLib := 200
      else
      begin
         UseLib := MoveNo;
         LibNo := 0;
      end;
   end;
end; { CalcLibNo }

procedure FindOpeningMove;
{ Finds an opening move from the library }
const Weight : array[0..6] of byte = (7,10,12,13,14,15,16);
var
  Cnt, r, p, CountP : byte;
begin
   r := Random(16);      { Calculate weighted Random Number in 0..16 }
   p := 0;
   while r >= Weight[p] do p := p + 1;
   for CountP := 1 to p do                 { Find corresponding node }
      NextLibNo(true);
   OpCount := Openings[LibNo] and 63;      { Generate the Move       }
   InitMovGen;
   for Cnt := 0 to OpCount do
      MovGen;
   MainLine[0] := Next;                 { Store the Move in MainLine }
   MainLine[1] := ZeroMove;
   MainEvalu := 0;
   MaxDepth := 0;
   LegalMoves := 0;
   InitNode(Nodes)
end; { FindOpeningMove }

procedure FindHintMove;
{ Calculates a mint move }
begin
   { if HintLine is empty then get the Move from the
     opening library or perform a 1 - Ply Search }
   if HintLine[0].MovPiece = Empty then
   begin
      AdjustMoves;
      CalcLibNo;
      Depth := 0;
      if LibNo > 0 then
         FindOpeningMove
      else
      begin
         Analysis := true;
         OpAn := false;
         FindMove(1);
      end;
      Depth := -1;
      HintLine[0] := MainLine[0];
      HintLine[1] := ZeroMove;
      HintEvalu := -MainEvalu;
   end;
end; { FindHintMove }

procedure ResetNewPos;
{ Resets global variables }
begin
   ResetMoves;
   CalcPieceTab;
   UseLib := 0;
   ClearHint;
end;

procedure StartUp;
begin
  Randomize;
  CalcAttackTab;
  MultiMove := false;
  AutoPlay := false;
  ResetOpening;
  Writeln;
  Writeln;
  Writeln('Opening CHESS script file...');
  Assign(OutputFile,'CHESS');      { The played games are stored }
  {$I-}
  Rewrite(OutputFile);             {  On the disc }
  {$I+}
  if IOresult <> 0 then
  begin
    Writeln('Cannot create CHESS output file.  Program aborted.');
    Halt;
  end;
  Writeln(OutputFile);
  Writeln(OutputFile, '             TURBO CHESS by Borland International');
  Writeln(OutputFile, '             ====================================');
  Writeln(OutputFile);
  SetScreen(Screen);  { set Screen Ptr for Color or MonoChrome Screen }
end; { StartUp }

type ControlVar = (ReadMove, CheckMove, GameMove);

var
  Dep     : DepthType;
  Control : ControlVar;       { determines flow of Control }

procedure NewGame(var FirstCall : boolean);
{ Start up new game }

procedure ClearPVTable;
var
  Color  : ColorType;
  Piece  : PieceType;
  Square : SquareType;
begin
  for Color := White to Black do
    for Piece := King to Pawn do
      for Square := 0 to $77 do
        PVTable[Color,Piece,Square] := 0;
end; { ClearPVTable }

begin  { NewGame }
  InLibrary := false;
  SingleStep := false;
  Level := Normal;                   { set Level }
  AverageTime := 15.0;
  MaxLevel := MaxPly;
  PrintCurLevel;
  ClearEvaluInfo;
  ResetGame(FirstCall);          { Reset variables }
  FirstCall := false;
  ResetMoves;
  if Openings[0] = 0 then UseLib := 0
  else UseLib := 200;
  MovTab[-1].Content := King;
  InitChessTime;
  ProgramColor := White;
  MoveNo := 0;
  ClearHint;
  ClearPVTable;
  PlayerMove := ZeroMove;
  Writeln(OutputFile);
  Writeln(OutputFile,
  ' No  Player program      Hint      Value Level  Nodes    Time');
  Writeln(OutputFile);
  InitNode(Nodes);
  Clock.TotalTime := 0.0;
  if AutoPlay then                 { set flow of Control }
    Control := GameMove
  else
    Control := ReadMove;
end; { NewGame }

procedure CheckOption(var Control : ControlVar);
{ Checks the Menu option entered }

procedure SetLevel;
var
  Color   : ColorType;
  Current : LevelType;
  Temp    : real;

function ReadReal(MaxLen : byte) : real;
{ Routine which inputs real Number with Error checking }
var
  Temp : MaxString;
  Code : integer;
  rl : real;

procedure InputStr(var s : MaxString; MaxLen : byte);
{ allows input of a string of alphanumeric characters
  Up till the specified Length }
var
  ch : char;
begin
  Write(s);
  repeat
    GetKey(ch);
    case ch of
      ^C  : Abort;                                 { Abort program }
      ^[  : if KeyPressed then GetKey(ch) { function/arrow: ignore }
            else;                         { ignore Esc             }
      #13 : ;
      #32..#127  : if Length(s) < MaxLen then
                   begin
                     ch := UpCase(ch);
                     Write(ch);
                     s := s + ch;
                   end;
      #8 : if Length(s) > 0 then
           begin
             GoToXY(WhereX - 1, WhereY);
             Write(' ');
             GoToXY(WhereX - 1, WhereY);
             Delete(s, Length(s), 1);
           end;
    end; { case }
  until ch = #13;
end;  { InputStr }

procedure Reject(Len : byte);
{ Notifies the user of illegal input and erases the input Line }
begin
  Write(^G);
  GoToXY(WhereX - Len,WhereY);
  for Len := 1 to Len do Write(' ');
  GoToXY(WhereX - Len,WhereY);
end; { Reject }

function Legal(rl : real) : boolean;
{ Checks to see if the input Number is in a valid range }
begin
  Legal := (rl > 0) and (rl <= 999);
end; { Legal }

var
  Done : boolean;

begin  { ReadReal }
  Temp := '';
  Done := False;
  TextColor(CommandPos.Color);
  TextBackground(CommandPos.Background);
  repeat
    InputStr(Temp, MaxLen);
    if Length(Temp) > 0 then
    begin
      Val(Temp, rl, Code);
      if (Code <> 0) or not Legal(rl) then
      begin
        Reject(Length(Temp));
        Temp := '';
       end;
    end
    else
      Done := true;
  until (((Code = 0) and Legal(rl))) or Done;
  if Done then
    rl := 0;
  ReadReal := rl;
end; { ReadReal }

begin  { SetLevel }
  Current := Level;
  DispLevelMenu;
  ReadCom('Level:  ', LevelMenu);  { get option from Command Line }
  LevelOption;                     { convert to scalar type       }
  if Length(Command) > 0 then
  begin
    case CurOpt of
      QuitLevel,
        Unknown : begin
                    PrintMenu;
                    Exit;
                  end;
      NormalSet   : Level := Normal;              { number of sec. per Move }
      FullSet     : Level := FullGameTime;   { number of min. for full game }
      DemoSet     : Level := DemoGame;       { Play as fast as the Opponent }
      InfiniteSet : Level := Infinite;                 { Analyse infinitely }
      PlySet      : Level := PlySearch;    { Search a fixed Number of plies }
      MateSet     : Level := MateSearch;              { Solve mate problems }
    end { case }
  end
  else
  begin
    PrintMenu;
    Exit;
  end;
  case Level of
    Normal : begin
               Ask('Time/Move (Sec): ');
               Temp := ReadReal(5);
               if Temp > 0 then AverageTime := Temp
               else Level := Current;
               for Color := White to Black do
                 with ChessTime[Color] do
                   TotalTime := (MoveNo DIV 2) * AverageTime;
             end;
    FullGameTime : begin
                     Ask('Time/Game (Min): ');
                     Temp := ReadReal(6);
                     if Temp > 0 then AverageTime := Temp
                     else Level := Current;
                     for Color := White to Black do
                     with ChessTime[Color] do
                       TotalTime := 0.0
                   end;
    PlySearch : begin
                  Ask('Ply-Depth: ');
                  Temp := ReadReal(4);
                  if Temp > 0 then
                    MaxLevel := Round(Temp)
                  else
                    Level := Current;
                end;
    else
      MaxLevel := MaxPly;
  end; { case }
  PrintCurLevel;          { Re-display the Main Menu upon Exit }
  PrintMenu;
end; { SetLevel }

procedure DisplayPVTable;
{ Display the P-V-table On the Screen (used for debuging) }
var   InPiece,PieceCount : PieceType;
      Square : SquareType;
      Color : ColorType;
      Show : boolean;

procedure ValueMenu;
begin
   ClearMenu;
   ClearMessage;
   GoToPos(MenuPos,2,2);
   Write('Piece to be evaluated');
   GoToPos(MenuPos,4,3);
   Write('e.g. WP,BK,WQ etc.');
   GoToPos(MenuPos,2,4);
   LightFirst('Q to Quit mode',MenuPos);
   GoToPos(CommandPos,2,3);
   Write('Enter <CR> to Clear');
end; { ValueMenu }

var
  Done : boolean;

begin
  Done := false;
  Color := White;
  InPiece := Empty;
  Show := false;
  repeat
    ValueMenu;
    ReadCom('Piece:  ',MainMenu);
    MainOption;
    if (CurOpt = QuitMain) and (Length(Command) > 0) or
       (Length(Command) = 0) and Show then
    begin
      SetUpScreen(FirstCall);
      PrintBoard;
      ValueMenu;
      Show := false;
      if Length(Command) > 0 then Done := true;
    end
    else
      if (Length(Command) >= 2) or (Length(Command) = 0) then
      begin
        if Length(Command) >= 2 then
        begin
          InPiece := Empty;
          for PieceCount := Empty to Pawn do
            if Command[2] = PieceLetter[PieceCount] then
              InPiece := PieceCount;
        end
        else
          Command :='';
        if (InPiece = Empty) or not (Command[1] in ['W','B']) then
        begin
          Error('Example: WK, WQ, WR,.., BP');
          Delay(1500);
        end
        else
        begin
          if Command[1] ='W' then
            Color := White
          else
            if Command[1] ='B' then Color := Black;
          for Square := 0 to $77 do
            if (Square and $88) = 0 then
              PrintValue(Square,
                         Round(PVTable[Color,InPiece,Square] / 2.56));
            Show := true;
        end;
    end;
  until Done;
  Command := '';
  CurOpt := Unknown;
  PrintBoard;
  PrintMenu;
end { DisplayPVTable };

procedure Edit;
{ Edit the position }
var   Sq : SquareType;
      InSquare : EdgeSquareType;
      InPiece,PieceCount : PieceType;
      KingCount, TotalCount : array[ColorType] of byte;
      Done : boolean;

procedure LoadIt( var Loaded : boolean);
{ Load the boad from the user specified file.}
const
  Width = 14;
var
  LoadFile : MaxString;

function LoadBoard(LoadFile : MaxString) : boolean;
{ LoadBoard is returned true if the file was
  loaded without errors }
var
  Load : Text;
  OK : boolean;

procedure LoadEachPiece(var Load : Text);
type
  SquareStr = string[80];

var
  CurSquare : SquareStr;
  Location : integer;

procedure NoBlanks(var CurSquare : SquareStr);
var
  i : byte;
begin
  i := 1;
  while (i <> 0) and (i <= Length(CurSquare)) do
  begin
    i := Pos(' ',CurSquare);
    if i <> 0 then
      Delete(CurSquare, i, 1);
  end;
  for i := 1 to Length(CurSquare) do
    CurSquare[i] := UpCase(CurSquare[i]);
end; { NoBlanks }

function CurPiece(p : char) : PieceType;
begin
  case p of
   'K' : CurPiece := King;
   'Q' : CurPiece := Queen;
   'R' : CurPiece := Rook;
   'B' : CurPiece := Bishop;
   'N' : CurPiece := Knight;
   'P' : CurPiece := Pawn;
  end;
end; {CurPiece}

function CurColor(c : char) : ColorType;
begin
  if c = 'W' then
    CurColor := White
  else
    CurColor := Black;
end; { CurColor }

procedure ReadHeader(var Load : Text;
                       var OK : boolean;
                     var Col  : ColorType );
var
  S : SquareStr;

begin
  S := '';
  if EOF(Load) then
    OK := False
  else
  begin
    Readln(Load,S);
    if Length(S) > 0 then
    begin
      NoBlanks(S);
      Col := CurColor(S[1])
    end
  end;
end; { ReadHeader }

function OtherColor(Cur : ColorType) : ColorType;
begin
  if (Cur = White) then
    OtherColor := Black
  else
    OtherColor := White;
end;

procedure LoadHeader(var Save : Text; var OK : boolean);
var
  CurPlayer,ProgColor : ColorType;
begin
  ReadHeader(Save,OK,CurPlayer);
  if OK then
  begin
    ReadHeader(Save,OK,ProgColor);
    if ProgColor = White then
    begin
      Turned := true; { Sets global variable so that Board is Turned }
      SetBorder;
      SetUpScreen(FirstCall);
      PrintBoard;
    end;
    ProgramColor := CurPlayer; { change active Color }
    Player := CurPlayer;
    ColorToPlay(Player);
    Opponent := OtherColor(Player);
  end;
end; { LoadHeader }

begin  { LoadEachPiece }
  CurSquare := '';
  OK := true;
  if not EOF(Load) then
    LoadHeader(Load,OK)
  else
    OK := false;
  while (not EOF(Load)) and OK do
  begin
    Readln(Load,CurSquare);
    if Length(CurSquare) > 0 then
    begin
      NoBlanks(CurSquare);
      Location := CalcSquare(CurSquare[3],CurSquare[4]);
      if (Location >= 0) and (Location <= $77) then
        InsertPiece(CurPiece(CurSquare[2]),CurColor(CurSquare[1]),Location)
      else
        OK := false;
    end;
  end;
end; { LoadEachPiece }

begin  { LoadBoard }
  Assign(Load,LoadFile);
  {$I-}
  Reset(Load);
  OK := IOresult = 0;
  {$I+}
  if not OK then
  begin
    Error('File not found');
    Delay(1500);
  end
  else
  begin
    ClearBoard;
    LoadEachPiece(Load);
    Close(Load);
  end;
  LoadBoard := OK;
end; { LoadBoard }

begin   { LoadIt }
  ClearMenu;
  GoToPos(MenuPos,0,2);
  Write('LOAD A GAME');
  GoToPos(MenuPos,0,4);
  Write('File name: ');
  HScroll(LoadFile, Width);
  if Length(LoadFile) > 0 then
  begin
    GoToPos(MenuPos,0,5);
    Loaded := LoadBoard(LoadFile);
  end
  else
  begin
    Error('Game not loaded');
    Delay(1500);
  end;
  DispEditMenu;
end; { LoadIt }

var
  Modified : boolean; { true if the Board changed }
  SaveCode : integer;

begin  { Edit }
  SetLastSquare;
  Done := false;
  Modified := false;
  DispEditMenu;
  repeat
    PrintBoard;
    repeat
      ReadCom('Choice: ', EditMenu)
    until Length(Command) > 0;
    case CurOpt of
      QuitEdit : if Modified then
               begin
                 { Check that position is Legal }
                 KingCount[White] := 0;
                 KingCount[Black] := 0;
                 TotalCount := KingCount;
                 for Sq := 0 to $77 do if (Sq and $88) = 0 then
                   with Board[Sq] do
                     if Piece <> Empty then
                     begin
                       TotalCount[Color] := TotalCount[Color] + 1;
                       if Piece = King then
                         KingCount[Color] := KingCount[Color] + 1;
                     end;
                   if (TotalCount[White] <= 16)
                     and (KingCount[White] = 1)
                     and (TotalCount[Black] <= 16)
                     and (KingCount[Black] = 1) then
                   begin
                     ResetNewPos;
                     if not Attacks(Player,PieceTab[Opponent,0].ISquare) then
                       Done := true
                     else
                     begin
                       Error('Illegal King position');
                     end;
                   end
                   else
                   begin
                     Error('Wrong number of pieces');
                   end;
               end
               else
                 Done := true;
          WhiteOpt : begin
                       ProgramColor := White;     { Change Color to White }
                       Player := White;
                       ColorToPlay(Player);
                       Opponent := Black;
                       Modified := true;
                     end;
          BlackOpt : begin
                       ProgramColor := Black;     { Change Color to Black }
                       Player := Black;
                       ColorToPlay(Player);
                       Opponent := White;
                       Modified := true;
                     end;
          Clear : begin
                    ClearBoard;
                    Modified := true;
                  end;
          Load : LoadIt(Modified);        { Load game Board from file }
          Save : begin
                   SaveIt(SaveCode);      { Save current Board to file,
                                          errors are reported in SaveIt }
                 end;
          Unknown : begin
                      InSquare := -1;                    { Enter Piece }
                      if Length(Command) = 3 then
                        InSquare := CalcSquare(Command[2],Command[3]);
                      InPiece := Empty;
                      for PieceCount := Empty to Pawn do
                        if Command[1] = PieceLetter[PieceCount] then
                          InPiece := PieceCount;
                      if (InPiece = Empty) and (Command[1] <>' ') or
                         (InSquare < 0) or (InPiece = Pawn) and
                         ((InSquare < 8) or (InSquare >= $70)) then
                      begin
                        Error('Unknown Edit Command');
                      end
                      else
                        with Board[InSquare] do
                        begin
                          Modified := true;
                          Piece := InPiece;
                          Color := ProgramColor;
                        end;
                    end;
        end; { case }
        PieceMessage;  { Redraw help Message }
      until Done;
    PrintMenu;   { Back to the Main Menu }
end { Edit };

begin  { CheckOption }
  MainOption;                    { set option case variable }
  Control := ReadMove;           { We will Read again unless
                                     Control is Reset below }
  Message('');
  case CurOpt of
    NewOne : begin
               NewGame(FirstCall);
             end;
    PlayIt : begin
               Control := GameMove;      { The program PLAYs Next Move }
             end;
    LevelSet : begin
                 SetLevel;
                 CurOpt := Unknown;  { Quit can be set to leave
                                        Level Menu but here it will
                                        cause the program to Quit }
               end;
      BackOne : begin
                  if MovTab[Depth].MovPiece = Empty then
                  begin                        { Take Back Last Move }
                    Error('Last move unknown');
                  end
                  else
                  begin
                    TakeBackMove(MovTab[Depth]);
                    ClearHint;
                    PrintBoard;
                    PrintComment;
                    ClearEvaluInfo;
                  end;
                end;
      ForwardOne : begin
                   { Go forward one move (opposite of Take Back) }
                     if Depth >= -1 then
                     begin
                       Error('Next move unknown');
                     end
                     else
                     begin
                       MakeMove(MovTab[Depth + 1]);
                       ClearHint;
                       PrintBoard;
                       PrintComment;
                       ClearEvaluInfo;
                     end;
                   end;
      Hint : begin
               FindHintMove;              { Find and print Hint Line }
               PrintHint(HintLine);
             end;
      Turn : begin
                { Turn the Board around On the Screen }
               Turned := not Turned;
               SetBorder;
               SetUpScreen(FirstCall);
               PrintBoard;
             end;
      EditBoard : begin
                    { Edit the position }
                    Edit;
                    CurOpt := Unknown;
                     { Quit can be set to leave Edit Menu
                       but here it will cause the program to Quit}
                    PrintBoard;
                    PrintComment;
                  end;
      Value : begin
                  { Display Piece-Value-table }
                DisplayPVTable;
                PrintBoard;
                PrintComment;
              end;
      Move : begin
               { Perform the Move entered from the keyboard }
               AdjustMoves;
               EnterKeyMove;
               StoreMoves;
               if not MultiMove then
                 Control := GameMove;
             end;
      Unknown : begin
                  Error('Unknown command');
                end;
   end; { case }
end; { CheckOption }

procedure ProgramMove(var Control : ControlVar);
{ performs move analysis }

type
   AnalysisControl = (Start, Return, Continue);
var
  MoveControl : AnalysisControl;  { flow of Control variable
                                    for this block }

procedure ThinkAwhile(var Control : ControlVar;
                  var MoveControl : AnalysisControl);
begin
{ Perform analysis in the opponents time of reflection.
  The program assumes that the Opponent will Perform the
  Hint Move, and starts analysing On it counter Move }

   if (HintLine[0].MovPiece=Empty) or MultiMove then
   begin
     Control := ReadMove;
     Exit;
   end;
   MoveMessage;
   Ask('Move:   ');                   { Ask for the opponents Move }
   Analysis := false;
   OpAn := true;
   AdjustMoves;                     { Setup surroundings as if the }
   MovTab[Depth + 1] := HintLine[0];      { Opponent had performed }
   MakeMove(MovTab[Depth + 1]);                   {  the hint move }
   StoreMoves;
   AdjustMoves;
   Depth := 0;                        { Analyse until something is }
   FindMove(MaxLevel);                {  entered from the keyboard }
   Depth := -1;
   OpAn := false;
   if Analysis then                 { if the Opponent did make the }
   begin                                  {  Hint Move then go and }
     MoveControl := Return;             { Perform the counter Move }
     Exit;
   end;
  TakeBackMove(MovTab[Depth]);          { restore the surroundings }
  if Length(Command) > 0 then
  begin
    Control := CheckMove;
    ClearMessage;
  end
  else
    Control := ReadMove;
end; { ThinkAwhile }

procedure StartMove(var MoveControl : AnalysisControl);
{ The program moves }
begin
   StartAnalysis;               { Calculate desired response Time }
   AdjustMoves;
   CalcLibNo;                   { Try to find a Move in }
   Depth := 0;                  {  the opening library  }
   if LibNo > 0 then
   begin
     OpeningLibMsg;
     InLibrary := true;
     FindOpeningMove;
     if AutoPlay then
     begin
       ScanKeys;
       if Length(Command) > 0 then
       begin
         MainOption;
         SmallTalk;
       end;
     end
   end
   else
   begin
     if InLibrary then
     begin
       InLibrary := false;
       ClearEvaluation;
     end;
     FindMove(MaxLevel);        { Perform the Search }
   end;
   Depth := -1;
   MoveControl := Return;
end; { StartMove }

procedure ReturnAnalysis(var Control : ControlVar;
                     var MoveControl : AnalysisControl);
var
  Dep     : DepthType;
begin
   MovTab[0] := MainLine[0];       { Copy the MainLine to HintLine }
   for Dep := 1 to MaxPly do
      HintLine[Dep - 1] := MainLine[Dep];
   HintEvalu := MainEvalu;
   if MovTab[0].MovPiece = Empty then
   begin
      HintLine[0] := ZeroMove;      { No Possible Move }
      if AutoPlay then
      begin
        NewGame(FirstCall);
        MoveControl := Start;
      end
      else
        Control := ReadMove;
      Exit;
   end; { if }

   FlashMove(MovTab[Depth + 1]);   { Flash and Perform the Move }
   EnterMove(MovTab[Depth + 1]);
   StoreMoves;
   Write(OutputFile,(MoveNo + 1) DIV 2 : 3,'. ');
   if (PlayerMove.MovPiece = Empty) and
      (Opponent = White) then
     Write(OutputFile,MoveStr(MovTab[0]),' ': 8)
   else
     Write(OutputFile,MoveStr(PlayerMove),MoveStr(MovTab[0]) : 8);
   Write(OutputFile,'    (',MoveStr(MainLine[1]),')',
         MainEvalu / 256 : 9 : 2,MaxDepth : 3,':',LegalMoves : 2);
   OutputNode(Nodes);
   Write(OutputFile, Clock.TotalTime : 8 : 1);
   Writeln(OutputFile);
   PlayerMove := ZeroMove;
   if AutoPlay then
   begin
      if (MoveNo >= 120) or (FiftyMoveCnt >= 100) or
         (Repetition(False) >= 3) or (MainEvalu <= -$880) then
        begin                 { Start a new game if this one is over }
          NewGame(FirstCall);
        end;
        MoveControl := Start;
      Exit;
   end;
   MoveControl := Continue;
end; { ReturnAnalysis }

begin  { ProgramMove }
  MoveControl := Start;
  repeat
    case MoveControl of
      Start   : StartMove(MoveControl);                   { figure out move }
      Return  : ReturnAnalysis(Control, MoveControl); { makes, notates move }
      Continue : ThinkAwhile(Control, MoveControl);  { Think while opponent }
    end; { case }                                    { thinks and moves     }
    ColorToPlay(Player);
  until (Control <> GameMove);
end; { ProgamMove }

procedure ReadOption(var Control : ControlVar);
{ Read commands from the main menu and calls SmallTalk
  to see if the command can be processed there }
begin
  Analysis := false;
  OpAn := false;
  repeat
    repeat
      MoveMessage;
      ReadCom('Move:   ', MainMenu);     { Get a Command from the }
    until Length(Command) > 0;           { keyboard               }
    SmallTalk;                           { process command        }
  until Length(Command) > 0;
  Control := CheckMove;
end; { ReadOption }

begin { Talk }
  StartUp;
  FirstCall := true;
  NewGame(FirstCall);
  repeat
    case Control of
      ReadMove  : ReadOption(Control);
      CheckMove : CheckOption(Control);
      GameMove  : ProgramMove(Control);
    end; { case }
    ColorToPlay(Player);
  until false;            { Program is interupted when user quits }
end; { Talk }
