{                          BRIDGE 4.0
            Copyright (c) 1985, 87 by Borland International, Inc.

  This program plays bridge, the most popular card game in
  the world.

  System requirements:  IBM PC and true compatibles
                        TURBO PASCAL 4.0
                        DOS 2.0 or later
                        192 K-bytes system memory minimum

  List of include modules:
    DISPLAY.BR     SCORE.BR       DEFAULTS.BR
    INIT.BR        INPUT.BR       BID.BR
    PLAY.BR

  List of data files:
    BRIDGE        - Script of games played.  Created in INIT.BR.

}

program Bridge;
{$R-}

Uses
  Crt,
  Dos;

{ Search control constants }

const maxdeals    = 3;   { Maximum number of deals in the a search }
      branchvalue = 0;   { Branch-value controlling the branching }
var   cheat:  boolean;   { Indicates cheating during play }

const searchfac   = 8;   { Weight of search evaluation }
      heurisfac   = 3;   { Weight of direct heuristics }

{ The 4 hands }
const
  north =  0;
  east  =  1;
  south =  2;
  west  =  3;

type
  handtype  = north..west;

{ The cards and bids }
const
  ace   = 14;
  king  = 13;

type
  valuetype = 2..ace;              { NT means No Trumph }
  trumptype = (club,diamond,heart,spade,nt);
  suittype  = club..spade;

  cardtype  = record
                suit:   suittype;    { Suit }
                value:  valuetype;   { Value }
                known,               { Card is known to player }
                played: boolean;     { Card has been played }
              end;

  leveltype = 0..7;                   { Bid levels }

  bidtype   = record                  { Representation of bids }
                level: leveltype;
                trump: trumptype;
              end;

const { Representation of the special bids }
      pass : bidtype = (level: 0;   trump: nt);
      dbl  : bidtype = (level: 0;   trump: club);
      rdbl : bidtype = (level: 0;   trump: diamond);

{ The DISTribution of the cards, and the state of the game.
  REL and Rdist contains the real situation.
  SIM and Sdist contains a simulated situation used in the search }

type
  cardnotype   = 0..12;               { Index in DIST }
  indextype    = 0..51;               { Used as index in DIST }

var   { DISTribution }
  Rdist, Sdist: array[handtype,cardnotype] of cardtype;

{ DATA about each of the 4 hands.
  L contains the length of the 4 suits.
  P contains number of points, including distribution points.
  L but not P is updated when a card is played.
  Thus P refers to the hand before any cards were played }

type  lengthtype = 0..13;
var
  rdata,sdata: array[handtype] of
                      record
                         l : array[suittype] of lengthtype;
                         p : integer;
                      end;



{ INFORMATION about the real deal, known by all players.
  This information is obtained mainly through the biddings.
  MINL contains the minimum length of the suits.
  Minus 1 means that the player have shown a void suit in the play.
  MINP and MAXP contains the minimum and maximum number of points,
  including distribution points.
  MINL is updated for each bid and when a card is played.
  MINP and MAXP are only updated at biddings.
  Thus MINP and MAXP refer to the hand before any cards
  were played }

type  infotype = record
                    minl:      array[suittype] of -1..13;
                    minp,maxp: integer;
                 end;
      PlayerHand = array[HandType] of boolean;
var   info: array[handtype] of infotype;



var   { The BIDS made in the game, indexed by BIDNO.
        BIDNO contains the number of bids made }
      bids:        array[-4..51] of bidtype;
      bidno:       0..52;

      contract:    bidtype;               { The contract }
      doubled:     0..2;                  { Doubling status }
      dummy:       handtype;              { The dummy hand }

      { The played game, card by card }
      game:        array[indextype] of
                      record
                         hand: handtype;       { Hand }
                         no:   cardnotype;     { Index to Rdist }
                      end;

      rel,sim:     record        { State of the game during play }
                      { Number of played cards }
                      round:       0..52;
                      { Tricks won by declarer }
                      wontricks:   0..13;
                      { Leading hand in this trick }
                      leadhand:    handtype;
                      { Lead suit }
                      leadsuit:    suittype;
                      { Best card in the trick }
                      bestcard:    cardtype;
                      { Player of best card }
                      besthand:    handtype;
{ Hand to play }
                      playinghand: handtype;
                   end;

      TrickNo,
      firstno:     0..13;                 { Trick number counters }

      GameNo:      integer;               { Game number }
      dealer:      handtype;              { First player to bid }
      computer:    PlayerHand;            { Indicates which hands }
                                          {  the computer plays }
      ShowTricks : boolean;               { Indicates whether past
                                            tricks will be shown }
      { The deals are saved on the disc }
      outputfile:  text;

{$I DISPLAY.BR   }
{$I SCORE.BR     }
{$I DEFAULTS.BR  }
{$I INIT.BR      }
{$I INPUT.BR     }
{$I BID.BR       }
{$I PLAY.BR      }

var
  BestBid    : BidType;                { Chosen bid }
  BestChoice : CardNoType;             { Chosen card }
  Redeal     : boolean;

begin { program body }
  InitScore;
  InitDefaults;
  InitGames;
  InitBids;
  NewScreen;
  repeat
    ResetGame;
    while not DoneBidding(BestBid) do;              { do bidding }
    CleanUpBids;
    if Contract.Level > 0 then
    begin
      DummyMessage;        { Play for your partner the declarer? }
      StartPlay;
      PlayCards(BestChoice, Redeal);
      ResetPartner;                { if you switched w/ declarer }
      if not Redeal then
      begin
        PrintResult;                      { Show contract winner }
        CalculateScore;
      end;
    end { if }
    else;                                     { Everyone passed! }
    ChangeDefaults;                     { Display defaults menu? }
  until false;                   { program terminates when user  }
end.                             { selects eXit on the main menu }

