;********************************************************************
;*                         GRAPHIX TOOLBOX 4.0                      *
;*       Copyright (c) 1985, 87 by  Borland International, Inc.     *
;*                                                                  *
;* Externals for Hercules Monochrome Graphics Adapter device driver *
;********************************************************************

DATA     SEGMENT  WORD PUBLIC
         EXTRN    ScreenGlb:DWORD, GrafBase:WORD, RamScreenGlb:BYTE
         EXTRN    XTextGlb:BYTE, YTextGlb:BYTE, ColorGlb:BYTE, Font:BYTE

         RightBit DB    0             ;Local variables used in DC routine
         XShr3    DW    0
DATA     ENDS

HardwareGrafBase  EQU 0B000H          ;Segment of graphics screen buffer
ScreenSizeGlb     EQU 16383           ;The size of the screen in words

CODE     SEGMENT  BYTE PUBLIC

         ASSUME   CS:CODE, DS:DATA

         PUBLIC   DC, DP, SwapScreen, InvertScreen  ;Public routines

; procedure DC(C : byte);
; { Draw the the character with ASCII code C }
; { at position (XTextGlb, YTextGlb).        }
; var
;   X, Y, I, Adr, Bit, Mask, F : word;
;
; begin
;   X := (XTextGlb-1) * 9;
;   Y := YTextGlb-1;
;   Bit := 7 - (X and 7);
;   Mask := not ($FF80 shr (7-Bit));
;   for I := 0 To 13 do
;   begin
;     Adr := BaseAddress(Y*14+I) + X shr 3;
;     F := (Font[C][I]) shl 1;
;     if ((C and $E0) = $C0) then
;       F := F or ((F and 2) shr 1);
;     MemW[GrafBase:Adr] := Swap(Swap(MemW[GrafBase:Adr])
;                           and Mask or (F shl Bit));
;   end;
; end; { DC }

CPtr              EQU     BYTE PTR [BP+6]

DC                PROC FAR

         PUSH     BP                       ;Save BP
         MOV      BP,SP                    ;Set up stack frame
         MOV      CH,CPtr                  ;CH := C;
         MOV      AL,CH
         AND      AL,0E0H
         CMP      AL,0C0H
         JNE      XX1
         MOV      AL,1
XX1:     AND      AL,1
         MOV      [RightBit],AL            ;RightBit := (CH in [$C0..$DF]);
         MOV      BL,[XTextGlb]            ;BL := XTextGlb;
         DEC      BL                       ;BL := XTextGlb - 1
         MOV      BH,[YTextGlb]            ;BH := YTextGlb;
         DEC      BH                       ;BH := YTextGlb - 1
         MOV      AL,CH
         XOR      AH,AH
         MOV      DX,AX
         MOV      CL,4
         SHL      AX,CL
         SHL      DX,1
         SUB      AX,DX
         MOV      SI,AX                    ;SI := Ofs(Font[CH]);
         MOV      AX,[GrafBase]
         MOV      ES,AX                    ;ES := GrafBase;
         XOR      DH,DH
         MOV      DL,BL
         MOV      CL,3                     ;CL := 3;
         SHL      DX,CL
         ADD      DL,BL
         ADC      DH,0                     ;DX := BL * 9;
         MOV      AX,DX
         SHR      AX,CL
         MOV      [XShr3],AX               ;XShr3 := DX shl CL;
         MOV      CL,DL
         AND      CL,7                     ;CL := DX and 7;
         MOV      DL,BH
         MOV      BX,0FF80H
         SHR      BX,CL
         NOT      BX                       ;BX := not($7FC0 shr CL);
         XOR      CL,7                     ;CL := CL xor 7;
         XOR      DH,DH
         MOV      AX,DX
         SHL      DX,1
         SHL      DX,1
         SHL      DX,1
         SUB      DX,AX
         SHL      DX,1                     ;DX := BH * 14;
         MOV      CH,0DH                   ;for CH := 0 to 13 do
Loop:    PUSH     BX                       ;begin
         PUSH     CX                       ;Save BX and CX
         XCHG     BX,CX
         XOR      AH,AH
         MOV      AL,BH
         ADD      AX,DX                    ;AX := DX + BH;
         MOV      BX,AX                    ;BX := AX;
         AND      BL,3                     ;BX := BX and 3;
         MOV      CL,0DH                   ;CL := 13;
         SHL      BX,CL                    ;BX := BX shl CL;
         SHR      AX,1
         SHR      AX,1                     ;AX := AX shr 2;
         MOV      AH,5AH
         MUL      AH                       ;AX := AX * 90;
         ADD      AX,BX
         ADD      AX,[XShr3]
         MOV      DI,AX                    ;DI := BX + AX + XShr3;
         POP      CX
         POP      BX                       ;Restore BX and CX
         MOV      AX,ES:[DI]               ;MemW[ES:DI] :=
         XCHG     AL,AH                    ;  Swap(Swap(MemW[ES:DI]) and BX);
         AND      AX,BX
         PUSH     BX
         MOV      BL,CH
         XOR      BH,BH
         MOV      BL,[SI+BX+Font]
         PUSH     AX
         MOV      AL,[RightBit]
         AND      AL,BL
         SHL      BX,1
         OR       BL,AL
         POP      AX
         SHL      BX,CL
         OR       AX,BX                    ;or (Font[C][CH] shl CL);
         XCHG     AL,AH
         MOV      ES:[DI],AX
         POP      BX
         DEC      CH                       ;end;
         JNS      Loop
         POP      BP                       ;Restore BP and return
         RET      2

DC                ENDP

; procedure DP(X, Y : word);
; var
;   I : word;
; begin
;   I := BaseAddress(Y) + X shr 3;
;   if ColorGlb = 255 then
;     Mem[GrafBase:I] := Mem[GrafBase:I] or 128 shr (X and 7)
;   else
;     Mem[GrafBase:I] := Mem[GrafBase:I] and ($FF7F shr (X and 7));
; end; { DP }

XPtr              EQU     WORD PTR [BP+8]
YPtr              EQU     WORD PTR [BP+6]

DP                PROC FAR

         PUSH     BP                       ;Save BP
         MOV      BP,SP                    ;Set up stack frame
         MOV      DX,YPtr                  ;DX := Y
         MOV      AX,3
         AND      AX,DX
         MOV      CL,0DH
         SHL      AX,CL
         SHR      DX,1
         AND      DX,0FFFEH
         MOV      BX,DX
         SHL      DX,1
         ADD      DX,BX
         MOV      BX,DX
         MOV      CL,4
         SHL      DX,CL
         SUB      DX,BX
         ADD      AX,DX                    ;AX := BaseAddress(Y)
         MOV      BX,XPtr                  ;BX := X
         MOV      DX,BX
         MOV      CL,03
         SHR      BX,CL                    ;BX := X shr 3
         ADD      BX,AX                    ;BX := BaseAddress(Y) + (X shr 3)
         MOV      CL,DL
         AND      CL,07                    ;CL := X and 7
         MOV      DL,80H                   ;DL := 128
         SHR      DL,CL                    ;DL := 128 shr (X and 7)
         MOV      ES,[GrafBase]            ;ES := base of graphics screen
         CMP      BYTE PTR [ColorGlb],0FFH ;Is ColorGlb = 255 ?
         JNZ      AndBit
         OR    ES:[BX],DL                  ;YES : OR the bit onto the screen
         JMP      Done
AndBit:  NOT      DL                       ;NO  : Invert the bits in DL
         AND   ES:[BX],DL                  ;      AND the bit onto the screen
Done:    POP      BP                       ;Restore BP
         RET      4                        ;Remove parameters and return

DP                ENDP

; procedure SwapScreen;
; { Exchanges the contents the of the displayed }
; { screen with the contents of the RAM screen  }
; const
;   HardwareGrafBase = $B000;
; var
;   ScanLine,
;   LineBase,
;   RamScrSeg  : word;
;   LineBuffer : array[0..XMaxGlb] of byte;
; begin
;   if RamScreenGlb then
;   begin
;     RamScrSeg := Seg(ScreenGlb^);
;     for ScanLine := 0 to YMaxGlb do
;     begin
;       LineBase := BaseAddress(Scanline);
;       Move(Mem[HardwareGrafBase:LineBase], LineBuffer, XMaxGlb+1);
;       Move(Mem[RamScrSeg:LineBase], Mem[HardwareGrafBase:LineBase], XMaxGlb+1);
;       Move(LineBuffer, Mem[RamScrSeg:LineBase], XMaxGlb+1);
;     end;
;   end;
; end; { SwapScreen }

SwapScreen          PROC FAR

           PUSH     BP                     ;Save BP
           MOV      BP,SP                  ;Set up stack frame
           MOV      AL,RamScreenGlb        ;Load boolean into AL
           XOR      AH,AH                  ;AH <- 0
           OR       AX,AX
           JZ       JumpOut                ;Exit if boolean is false
           LES      DI,[ScreenGlb]         ;ES <- Seg(ScreenGlb^)
           PUSH     DS                     ;Save DS
           MOV      AX,HardwareGrafBase    ;
           MOV      DS,AX                  ;DS <- Seg of hardware screen
           MOV      CX,ScreenSizeGlb       ;CX <- Size of screen in words
           XOR      BX,BX                  ;BX <- word offset of zero
SwapWords: MOV      AX,[BX]                ;AX <- word from hardware screen
           XCHG     AX,ES:[BX]             ;AX <-> soft screen
           MOV      [BX],AX                ;Hardware screen <- AX
           INC      BX
           INC      BX                     ;Increment word offset by 2
           LOOP     SwapWords              ;Swap next byte
           POP      DS                     ;Restore DS
JumpOut:   POP      BP                     ;Restore BP
           RET                             ;Return

SwapScreen        ENDP

; procedure InvertScreen;
; { Invert the contents of screen memory }
; var
;   Offset : word;
; begin
;   for Offset := 0 to (16383 shl 1)+1 do
;     Mem[GrafBase:Offset] := Not(Mem[GrafBase:Offset]);
; end; { InvertScreen }

InvertScreen      PROC FAR

         PUSH     BP                  ;Save BP
         MOV      BP,SP               ;Set up stack frame
         PUSH     DS                  ;Save data segment
         MOV      AX,[GrafBase]
         MOV      DS,AX               ;DS := base address of graphics screen
         MOV      CX,ScreenSizeGlb    ;CX := Size of screen in integers
         XOR      BX,BX               ;Zero out BX
InvWrd:  NOT      WORD PTR [BX]       ;Invert word at DS:BX
         INC      BX
         INC      BX                  ;Increment to next word
         Loop     InvWrd
         POP      DS                  ;Restore data segment
         POP      BP                  ;Restore BP
         RET                          ;Return

InvertScreen      ENDP

CODE     ENDS
         END








