
{           Copyright (c) 1985, 87 by Borland International, Inc.            }

program PieHisto;

{$I Float.inc}  { Determines what type Float means. }

uses
  Dos, Crt, GDriver, GKernel, GWindow, GShell;

procedure PieHistoDem;
var
  Sum, X1, Y1, X2, Y2, InRadius, OutRadius : Float;
  I, N : integer;
  A : PieArray;
  B : PlotArray;
  Ch : char;
  NumText : WrkString;

begin
  N := 5;                                { The number of data points }
  A[1].Area := 25;                       { Initialize the pie array }
  A[2].Area := 17.5;
  A[3].Area := 9.6;
  A[4].Area := 21;
  A[5].Area := 35;
  A[1].Text := 'JAN. ';
  A[2].Text := 'FEB. ';
  A[3].Text := 'MAR. ';
  A[4].Text := 'APR. ';
  A[5].Text := 'MAY  ';

  for I := 1 to N do                      { Init the histogram array }
    B[I, 2] := A[I].Area;

  ClearScreen;
  SetColorWhite;

  DefineWindow(1, 0, 0, XMaxGlb, YMaxGlb);
  DefineHeader(1, 'BOTH A PIE AND A BAR CHART');  { Set up a window }
  SelectWindow(1);
  SetHeaderOn;
  SetBackground(0);
  DrawBorder;

  for I := 1 to N do                      { Type the info in the up-rt corner }
  begin
    GotoXY(60, 4 + I);                    { Goto correct line }
    Write(A[I].Text, '=');                { Type the lable info }
    Str(A[I].Area:6:2, NumText);          { Format the numeric info }
    Write(NumText);                       { Type the numeric info }
  end;

  DefineWindow(2, Trunc(XMaxGlb / 10), Trunc(YMaxGlb / 10),
                  Trunc(XMaxGlb * 6 / 10), Trunc(YMaxGlb * 7 / 10));
  DefineHeader(2, 'A PIE CHART');         { Set up a window }
  DefineWorld(2, 0, 0, 1000, 1000);
  SelectWorld(2);
  SelectWindow(2);
  SetHeaderOn;
  SetBackground(0);
  DrawBorder;

  A[1].Area := -A[1].Area;               { Move the first segment outward }
  SetAspect(1.0);                        { Set the aspect ratio }

  X1 := 500;                             { Set the center to mid screen }
  Y1 := 500;

  X2 := 600;                             { Set the start of the circle }
  Y2 := 350;

  InRadius := 0.7;                       { Set the ends of the lable line }
  OutRadius := 1.25;

  DrawCartPie(X1, Y1, X2, Y2, InRadius, OutRadius, A, N, 2, 1); { Draw the pie }

  A[1].Area := -A[1].Area;               { Reset the sign }

  DefineWindow(3, Trunc(XMaxGlb / 2), Trunc(YMaxGlb / 2),
                  Trunc(XMaxGlb * 9 / 10), Trunc(YMaxGlb * 9 / 10));
  DefineHeader(3, 'A BAR CHART');        { Set up a window }
  DefineWorld(3, 0, 0, 10, 60);
  SelectWorld(3);
  SelectWindow(3);
  SetHeaderOn;
  SetBackground(0);
  DrawBorder;

  DrawHistogram(B, N, true, 5);

  for I := 1 to N do                     { Draw the bar chart lables }
  begin
    DrawTextW((10 / N) * (I - 1), 10, 1, '   ' + A[I].Text); { Draw the text }
    Str(A[I].Area:6:2, NumText);                             { Format the number }
    DrawTextW((10 / N) * (I - 1), 16, 1, ' ' + NumText);     { Draw the number }
  end;
end; { PieHistoDem }

begin { PieHisto }
  InitGraphic;                           { Initialize the graphics system }

  PieHistoDem;                           { Do the demo }

  repeat until KeyPressed;               { Wait until a key is pressed }

  LeaveGraphic;                          { Leave the graphics system }
end. { PieHisto }

