
{           Copyright (c) 1985, 87 by Borland International, Inc.            }

program FlowDemo;

{$I Float.inc}  { Determines what type Float means. }

uses
  Dos, Crt, GDriver, GKernel, GWindow, GShell;

procedure FlowChartDemo;
var
  X1, Y1, X2, Y2, I, Count : integer;
  Temp : WrkString;

procedure DrawArrowHor(X1, Y1, X2, Y2 : integer);
{ Draw horizontal arrow with tip at point (X2, Y2) }
begin
  DrawLine(X1, Y1, X2, Y2);
  if X2 > X1 then
    begin
      DrawLine(X2 - 4, Y2 - 2, X2, Y2);
      DrawLine(X2 - 4, Y2 + 2, X2, Y2);
    end
  else
    begin
      DrawLine(X2 + 5, Y2 - 2, X2, Y2);
      DrawLine(X2 + 5, Y2 + 2, X2, Y2);
    end;
end; { DrawArrowHor }

procedure DrawArrowVer(X1, Y1, X2, Y2 : integer);
{ Draw vertical arrow with tip at point (X2, Y2) }
begin
  DrawLine(X1, Y1, X2, Y2);
  if Y2 > Y1 then
    begin
      DrawLine(X2 - 2, Y2 - 3, X2, Y2);
      DrawLine(X2 + 2, Y2 - 3, X2, Y2);
    end
  else
    begin
      DrawLine(X2 - 2, Y2 + 3, X2, Y2);
      DrawLine(X2 + 2, Y2 + 3, X2, Y2);
    end;
end; { DrawArrowVer }

procedure Blink(Count, Time : integer);
{ Blink the current window }
var
  I : integer;
begin
  for I := 1 to Count do
  begin
    Delay(Time);
    InvertWindow;
  end;
end; { Blink }

begin { FlowChartDemo }
  DefineWindow(1, 0, 0, 79, 190);         { Define the 'FLOW CHART' window }
  DefineWindow(2, 12, 20, 25, 40);        { Define the 'START' window }
  DefineWindow(3, 15, 55, 22, 75);        { Define the 'I=1' window }
  DefineWindow(4, 11, 110, 26, 130);      { Define the 'IF I<=5' window }
  DefineWindow(5, 47, 90, 56, 110);       { Define the 'I=I+1' window }

  ClearScreen;                            { Draw the surrounding window }
  SetColorWhite;
  DefineHeader(1, 'A FLOW CHART');
  SetHeaderOn;
  SelectWindow(1);
  DrawBorder;
  SetHeaderOff;

  SelectWindow(2);                        { Draw the 'START' window }
  DrawBorder;
  DrawText(125, 27, 2, 'START');
  SetWindowModeOff;
  DrawArrowVer(151, 40, 151, 55);         { Draw the connecting line }
  SetWindowModeOn;

  SelectWindow(3);                        { Draw the 'I=1' window }
  DrawBorder;
  DrawText(136, 63, 2, 'I=1');
  SetWindowModeOff;
  DrawArrowVer(151, 75, 151, 110);        { Draw the connecting line }
  SetWindowModeOn;

  SelectWindow(4);                        { Draw the 'IF I>=5' window }
  DrawBorder;
  DrawText(108, 118, 2, 'IF I<=5');
  DrawStraight(215, 417, 120);            { Draw the connecting lines }
  SetWindowModeOff;
  DrawArrowVer(417, 120, 417, 110);
  DrawArrowVer(151, 130, 151, 155);
  SetWindowModeOn;
  SelectWindow(1);
  DrawText(300, 110, 2, 'YES');
  DrawText(160, 137, 2, 'NO');

  SelectWindow(5);                        { Draw the 'I=I+1' window }
  DrawBorder;
  DrawText(390, 98, 2, 'I=I+1');
  SetWindowModeOff;
  DrawLine(417, 90, 417, 80);             { Draw the connecting lines }
  DrawArrowHor(417, 80, 151, 80);

  SetAspect(1.0);                         { Draw the 'END' circle }
  DrawCircle(151, 165, 25);
  SelectWindow(1);
  DrawText(137, 163, 2, 'END');
  SetWindowModeOn;
  SetHeaderOn;

  CopyScreen;                             { Make an image of this screen }
                                          { on the virtual RAM screen }

  DefineWindow(2, 15, 21, 22, 39);        { Set up the moving window }
  SelectWindow(2);
  SetBackground(0);
  DrawBorder;
  InvertWindow;
  Delay(1000);
  InvertWindow;

  Temp := '123456';                       { Initialize the number array }
  MoveVer(35, true);                      { move window over init statement }
  DrawText(139, 63, 2, 'I=' + Temp[1]);   { 'init' it }
  Blink(30, 50);
  MoveVer(55, true);                      { Move it down to increment loop }

  for Count := 2 to 6 do                  { Do increment loop }
  begin
    Delay(500);
    MoveHor(33, true);
    MoveVer(-20, true);
    SetBackground(0);
    DrawBorder;
    DrawText(400, 98, 2, 'I=' + Temp[Count]);
    Blink(30, 50);
    MoveVer(-20, true);
    MoveHor(-33, true);
    MoveVer(40, true);
  end;

  InvertWindow;
  Delay(1000);
  MoveVer(46, true);                      { Move to the 'END' statement }
  Blink(30, 50);

  MoveHor(45, true);                      { Move back up to the top }
  MoveVer(-136, true);
  MoveHor(-45, true);
  SetHeaderOn;
end; { FlowChartDemo }

begin
  InitGraphic;                            { Initialize the graphics system }

  FlowChartDemo;                          { Do the demo }

  repeat until KeyPressed;                { Wait until a key is pressed }

  LeaveGraphic;                           { Leave the graphics system }
end. { FlowDemo }

