
{           Copyright (c) 1985, 87 by Borland International, Inc.            }

program DrawStandardText;

{$I Float.inc}  { Determines what type Float means. }

uses
  Dos, Crt, GDriver, GKernel;

const
  MaxWorldX : Float = 1000.0;
  MaxWorldY : Float = 1000.0;

var
  I : integer;
  CharHeight, CharWidth : Float;

begin
  InitGraphic;                      { Initialize the graphics system }

  DefineWorld(1, 0, 0, MaxWorldX, MaxWorldX);    { Define the world to draw in }
  SelectWorld(1);                   { Select the world and window }
  SelectWindow(1);
  DrawBorder;

  GotoXY(39, 12);                   { Goto the center of the text screen }
  Writeln('* <- This should be at the center '); { Write two lines of text }
  Write('This should be on the next line');

  CharWidth := MaxWorldX / 80;      { Compute a character's width }
  CharHeight := MaxWorldY / 25;     { Compute a character's height }

  DrawSquare(9*CharWidth, 7*CharHeight,          { Draw box at text loc [10,8] }
            (22*CharWidth)+2, (8*CharHeight)+2, true);

  GotoXY(10, 8);                    { Position cursor }

  Write('Text in a box');           { Write text in it }

  repeat until KeyPressed;          { Wait until a key is pressed }
  LeaveGraphic;                     { Leave the graphics system }
end. { DrawStandardText }
