
{           Copyright (c) 1985, 87 by Borland International, Inc.            }

program BeziDemo;

{$I Float.inc}  { Determines what type Float means. }

uses
  Dos, Crt, GDriver, GKernel, GWindow, GShell;

procedure ClearToEol;
{ Procedure to clear to end of line }
var
  I : integer;
begin
  for I := 1 to 80 do
    Write(' ');
end; { ClearToEol }

procedure ReadInput(var S : WrkString);
const
  Cr = #13;
  Bs = #8;
var
  Count : integer;
  Ch    : char;
begin
  Count := 0;
  S := '';
  repeat
    Ch := ReadKey;
    case Ch of
      Bs : begin
             if Count > 0 then
             begin
               Write(Ch);
               ClrEol;
               Delete(S, Length(S), 1);
               Dec(Count);
             end;
           end;
    else
      if Ch <> Cr then
      begin
        Write(Ch);
        S := S + Ch;
        Count := Count + 1;
      end;
    end;
  until Ch = Cr;
end; { ReadInput }

procedure BezierDem;

var
  Result, I, MaxControlPoints, MaxIntPoints : integer;
  DummyX, DummyY : Float;
  A, B : PlotArray;
  Break : boolean;
  DummyS, Temp2, Temp : WrkString;

begin
  MaxControlPoints := 7;               { Initialize everything }
  MaxIntPoints := 15;

  A[1, 1] := 1;   A[2, 1] := 1.5; A[3, 1] := 2;   A[4, 1] := 2.5;
  A[5, 1] := 3;   A[6, 1] := 4;   A[7, 1] := 5;   A[1, 2] := 2;
  A[2, 2] := 1.5; A[3, 2] := 1;   A[4, 2] := 2.5; A[5, 2] := 4;
  A[6, 2] := 4.5; A[7, 2] := 5;

  ClearScreen;                         { Set up screen }
  SetColorWhite;
  DefineWorld(1, 0, 0, 6.33, 7.0);     { Set world so rulers are good }
  SelectWorld(1);
  DefineWindow(1, 0, 0, XMaxGlb, 17 * YMaxGlb div 20);
  SelectWindow(1);
  SetBackground(0);
  DrawBorder;

  Break := false;                      { Init exit flag }

  repeat
    DrawAxis(7, -7, 0, 0, 0, 0, 0, 0, false);
    SetLinestyle(1);                   { Draw polygon between points }
    DrawPolygon(A, 1, MaxControlPoints, 4, 2, 0);
    Bezier(A, MaxControlPoints, B, MaxIntPoints);  { Do bezier operation }
    SetLinestyle(0);                   { Plot it }
    ResetAxis;
    DrawPolygon(B, 1, MaxIntPoints, 0, 0, 0);

    repeat
      GotoXY(1, 24);                   { Clear out old text }
      ClearToEol;
      GotoXY(1, 25);
      ClearToEol;
      GotoXY(1, 23);
      ClearToEol;
      GotoXY(1, 23);                   { Get point to change }
      Write('Enter the number of the point to change (0 to quit) :  ');
      GotoXY(55, 23);
      ReadInput(Temp);
      Val(Temp, I, Result);
    until I in [0..MaxControlPoints];

    if I > 0 then
      begin
        repeat
          GotoXY(1, 24);               { Get new values for x and y }
          Write('Old position : [', A[I,1]:4:2, ',', A[I,2]:4:2, ']');
          GotoXY(40, 24);
          Write('   New position  x:  ');
          GotoXY(60, 24);
          ReadInput(DummyS);
          while DummyS[1] = ' ' do
            Delete(DummyS, 1, 1);
          Temp := DummyS;
          GotoXY(40, 25);
          Write('   New position  y:  ');
          GotoXY(60, 25);
          ReadInput(DummyS);
          while DummyS[1] = ' ' do
            Delete(DummyS, 1, 1);
          Temp2 := DummyS;
          Val(Temp, DummyX, Result);
          Val(Temp2, DummyY, Result);
        until ((DummyX >= X1WldGlb) and (DummyX <= X2WldGlb)) and
              ((DummyY >= Y1WldGlb) and (DummyY <= Y2WldGlb));

        SetLinestyle(1);               { Erase old curve }
        SetColorBlack;
        DrawAxis(0, 0, 0, 0, 0, 0, 0, 0, false);
        DrawPolygon(A, 1, MaxControlPoints, 4, 2, 0);
        SetLinestyle(0);
        DrawAxis(0, 0, 0, 0, 0, 0, 0, 0, false);
        DrawPolygon(B, 1, MaxIntPoints, 0, 0, 0);
        A[I, 1] := DummyX;
        A[I, 2] := DummyY;
        SetColorWhite;
      end
    else
      Break := true;                   { Done }
  until Break;
end; { BezierDem }

begin
  InitGraphic;                         { Initialize the graphics system }

  BezierDem;                           { Do the demo }

  LeaveGraphic;                        { Leave the graphics system }
end. { BeziDemo }

