;JRCarts loader
;jeff leyda
;2014 
;jeff@silent.net
;

MAX_GAMES	EQU	8
LOAD_SEG	EQU	2000h

	cseg segment
        assume cs: cseg,ds:cseg,es:cseg,ss:cseg 
	org 0h
main:  
	mov	ax, 7c0h	; adjust for boot offset
	mov	ds, ax

	mov	ax, 2		; set 80x25
 	int	10h  
	mov	ax, 500h
	int	10h
	
	xor	bx, bx		; page# for these routines
    	call	printTop
    	lea     si, ds:menuText	
       	call	printString
	call	printBottom

input:  
                      
      	xor     ax, ax
        int     16h             

	sub     al, 30h 	; make input a value
        cmp     al, MAX_GAMES
        ja      input		; retry dummy!

	lea	si, loadTbl
	shl	al, 1		; make a word ptr
	xor	ah, ah
	add	si, ax		; si now points to load info


; si now points to start of data
loadit:
 	mov     bx, LOAD_SEG	; segment to load games into
        mov     es, bx
 

	mov     dx, 100h	; side 1, drive A:
        mov     bx, 0		; starting offset
	mov	ch, [si]	; starting track #
	mov	di, [si+1]	; counter
	and	di, 0fh
loadLoop:	
	mov	cl, 1		; sector 1
	mov     ax, 209h 	; read, always 9 sectors
 	int     13h             
	jc	main		; complete fail on disk error
	
	add	bx, 9 * 512	; new offset

	add	ch, dh		; inc track if we switched sides
	xor	dh, 1		; next side
	dec	di
	jnz	loadLoop


	; cleanup floppy load before launching cart data
	xor	ax, ax
	int	13h		; reset floppy

	push	es
	mov	ax, 40h
	mov	es, ax
	mov	dl, es:[6ch]
	add	dl, 40		; wait about 2 seconds for floppy to quit
@@:	
	cmp	es:[6ch], dl
	jne	@b
     	pop	es

	mov	al, 20h
	out	20h, al


	xor	ax, ax
	mov	ds, ax
	mov     ax, LOAD_SEG	; jump to segment:3 to start rom
        mov     bx, 3
        push    ax
        push    bx
        retf


; ---------------------------------------------------------------------------
; starting track, # of loads.  
; games always start on side 1 each load always 9
; sectors
loadTbl:   	db	0,2		; scubaventure (2 loads @ track 0)
	     	db	1,2		; mouser
	   	db	2,4	 	; river raid (4 loads @ track 2)
		db	4,4		; pitfall II
		db	6,10		; demon attack
		db	11,10		; microsurgeon		
		db	16,2		; crossfire
		db	17,2		; mine shaft 
		db	18,14


; input SI->raw string
printString proc
	lodsb
	cmp	al, 0
	jz	exit
	mov	ah, 0eh
	int	10h
	jmp	printString
exit:
	ret
printString endp

printTop proc
	mov	ah, 0eh
	mov	al, 218 ; 
	int	10h

	mov	cx, 78
@@:
	mov	al, 196 ; 	
	mov	ah, 0eh
	int	10h
   	loop 	@b
	mov	al, 191 ; 
	mov	ah, 0eh
	int	10h
	ret
printTop endp

printBottom proc
	mov	ah, 0eh
	mov	al, 192 ; 
	int	10h

	mov	cx, 78
@@:
	mov	al, 196 ; 	
	mov	ah, 0eh
	int	10h
   	loop 	@b
	mov	al, 217 ; 
	mov	ah, 0eh
	int	10h
	ret
printBottom endp

menutext        db "| 0. ScubaVenture               1. Mouser                   2. River Raid      |"
                db "| 3. Pitfall II                 4. Demon Attack             5. Microsurgeon    |"
                db "| 6. Crossfire                  7. Mine Shaft               8. PCjr Colorpaint |"
		db 0

org 510	
db 55h,0aah  
	      
cseg ends
end main
