/********** The Son of Tetris Project ************/

/************ VIDEO/DISPLAY functions ***********/


#include <conio.h>
#include <dos.h>
#include <stdio.h>
#include <stdlib.h>

#include "sot.h"

#define COFF 28       /* Column offset main display */
#define LOFF 0        /* Line offset */

#define SCOR_COFF 55
#define SCOR_LOFF 5
#define CRIB_COFF 3
#define CRIB_LOFF 3

#define HOT_CHAR ''

static unsigned     vseg;                     /* Video segment */
static void        *screen_buf;               /* Screen held here */
static int          x_cur_pos, y_cur_pos;     /* Initial cursor position */
static int          cursor_val = FALSE;

const  unsigned char FILL_CHAR = '';

#define vpoke(adr, chr)  poke(vseg, adr, chr)



static int vmode(void)
{
  union REGS rg;

  rg.h.ah = 15;
  int86(0x10,&rg, &rg);
  return rg.h.al;
} /* vmode */



static int get_cursor_state(void)
{
  union REGS rg;

  rg.h.ah = 15;
  int86(0x10,&rg, &rg); /*  get current display page to bh */
  rg.h.ah = 3;
  int86(0x10,&rg, &rg); /*  get current display page to bh */
  return rg.x.cx;
} /* get_cursor_state */



static void set_cursor_state(int state)
{
  union REGS rg;

  rg.h.ah = 1;
  rg.x.cx = state;
  int86(0x10,&rg, &rg);
} /* set_cursor_state */



void cursor_off(void)
{
  if (!cursor_val)
    cursor_val = get_cursor_state();
  set_cursor_state(cursor_val | 0x2000);
}


void cursor_on(void)
{
  set_cursor_state(cursor_val);
}



void  p_arena(int left,int top,int right,int bottom)
{
  static unsigned start_offset = ((SCRW * (LOFF - 1)) + COFF) * 2;
  register unsigned x, col_offset, row_offset;
  long  attribute;

  left = (left > 0) ? left : 1;  /* Force display only within boundaries */
  right = (right < BLW-1) ? right : BLW-2;
  top = (top > 0) ? top : 1;
  bottom = (bottom < BLH-1) ? bottom : BLH-2;

  for (row_offset = start_offset + 2 * SCRW * top + 4 * left;
       top <= bottom;
       top++, row_offset += 2 * SCRW)
  {
    for (col_offset = row_offset, x = left;
	 x <= right;
	 x++,col_offset +=4)
    {
      switch(arena[x][top])
      {
        case CLEAR:
	  attribute = (x & 1) ?  ' ': FILL_CHAR;
          attribute |= ((BLACK << 4) + WHITE) << 8;
          vpoke(col_offset,attribute);
          vpoke(col_offset+2,attribute & 0xFF00);
	  break;

        case BORDER:
	  attribute = '?';
          attribute |= ((BLACK << 4) + WHITE) << 8;
	  break;

        default:
	  if (arena[x][top] > BLINK)
	  {
	    attribute = HOT_CHAR;
            attribute |= ((arena[x][top] << 4) + (arena[x][top] | DARKGRAY))
				<< 8;
	  } /* hot object */
	  else
	  {
	    attribute = ' ';
	    attribute |= ((arena[x][top] << 4) + BLACK) << 8;
	  }
          vpoke(col_offset,attribute);
          vpoke(col_offset+2,attribute);
	  break;

      } /* switch */
    } /* for each column */
  } /* for each row */

} /* p_arena */



void      v_kill_row(int  t_row)
{
  window(COFF+ 3, LOFF + 1, COFF + (BLW-1) * 2, LOFF + t_row);
  gotoxy(1,1);
  insline();
  window(1,1,80,25);
  p_arena(1,1,BLW-2,1);
}         /* v_kill_row */



static void p_surround(void)
{
  int i;
  for (i = (LOFF - 1) + 2; i < (LOFF - 1) + BLH; i++)
  {
    gotoxy(COFF + 2,i); putch('');
    gotoxy(COFF+ 2 * BLW-1,i); putch('');
  }
  gotoxy(COFF + 3, (LOFF - 1) + BLH);
  for (i = 0; i < 2 * (BLW - 2); i++)
    putch('');
  gotoxy(COFF + 2, (LOFF - 1) + BLH); putch('');
  gotoxy(COFF + 2 * BLW - 1, (LOFF - 1) + BLH); putch('');

} /* p_surround  */


void  init_video(void)
{
  screen_buf = malloc(80 * 25 * 2);
  gettext(1,1,80,25,screen_buf);
  x_cur_pos = wherex();
  y_cur_pos = wherey();
  cursor_off();
  clrscr();            /* Clear screen */
  vseg = (vmode() == 7) ? 0xB000:0xB800;  /* Set monochrome/colour segment */

  p_surround();
  gotoxy(SCOR_COFF,SCOR_LOFF);
  cprintf("Level :");
  gotoxy(SCOR_COFF,SCOR_LOFF+1);
  cprintf("Score :");
  gotoxy(SCOR_COFF,SCOR_LOFF+2);
  cprintf("Lines :");
  gotoxy(SCOR_COFF,SCOR_LOFF+4);
  cprintf("Next shape :");

  gotoxy(CRIB_COFF,CRIB_LOFF);
  cprintf("       SOT Crib");
  gotoxy(CRIB_COFF,CRIB_LOFF+2);
  cprintf("<-: Left        P: Pause");
  gotoxy(CRIB_COFF,CRIB_LOFF+3);
  cprintf(" r: Rotate      S: Sound");
  gotoxy(CRIB_COFF,CRIB_LOFF+4);
  cprintf("->: Right     ESC: Abort");
  gotoxy(CRIB_COFF,CRIB_LOFF+5);
  cprintf(" l: Level   SPACE: Drop");


}   /* init_video */


void  end_video(void)
{
  puttext(1,1,80,25,screen_buf);
  gotoxy(x_cur_pos,y_cur_pos);
  cursor_on();
}     /* end_video */


void  update_score(unsigned level,
                   long     score,
		   unsigned lines_del,
		   SHP_TYPE *next_sh,
		   int show_shape)
{
  int x,y, *map_ptr;
  gotoxy(SCOR_COFF + 8,SCOR_LOFF);
  cprintf("%7u",level);
  gotoxy(SCOR_COFF + 8,SCOR_LOFF+1);
  cprintf("%7ld",score);
  gotoxy(SCOR_COFF + 8,SCOR_LOFF+2);
  cprintf("%7u",lines_del);

  window(SCOR_COFF, SCOR_LOFF + 6,SCOR_COFF + 15, SCOR_LOFF + 10);
  clrscr();
  window(1,1,80,25);
  if (show_shape)
  {
    map_ptr = next_sh -> map[0];
    for (y = 0; y < next_sh ->ht; y++)
    {
      gotoxy(SCOR_COFF, SCOR_LOFF + 6 + y);
      for (x = 0; x < next_sh ->wd; x++,map_ptr++)
      {
        if (*map_ptr)
          textattr((next_sh ->col << 4) + BLACK);
        else
          textattr((BLACK << 4) + BLACK);

        putch(' '); putch(' ');
      } /* for x */
    } /* for y */
  } /* if show_shape */
  textattr((BLACK << 4) + LIGHTGRAY);

}       /* update_score */
