/********** The Son of Tetris Project ************/

/************  GAME ***********/

#include <conio.h>
#include <dos.h>
#include <setjmp.h>
#include <stdlib.h>


#include "sot.h"

#define MAX_LEVEL 9
#define ACT_LEVEL 3  /* level at which extra shapes start appearing */
#define MIN_SHAPES 7 /* minimum number of shapes */
#define ADD_SHAPE MIN_SHAPES - ACT_LEVEL + 1
#define MAX_SHAPE 20 /* maximum number of shapes allowed before upping level */

#define DELAY_TIME 120 /* Loop, unit of time */

int      mv(drctn_type dt, OBJ_TYPE *cur_obj, int amt);   /* move object */
int      insrt(OBJ_TYPE *cur_obj,SHP_TYPE *next_sh);      /* insert object */
int      getkey(void);


static  SHP_TYPE *next_sh;  /* next shape to appear */
static  unsigned  level;    /* Level at which game is being played */
static  long      score;
static  unsigned  lines_del;/* Lines deleted */
static  int       sound_on = TRUE; /* Controls use of sound FX */
static  int       show_shape = TRUE; /* show next shape */
static  unsigned  shape_count;

static void get_next_shape(void)
{
  unsigned new_shape_no, choice_of_shapes;
  if (level < ACT_LEVEL)
    choice_of_shapes = MIN_SHAPES;
  else
    choice_of_shapes = (no_of_shapes < level + ADD_SHAPE) ?
				       no_of_shapes : level + ADD_SHAPE;
  new_shape_no = (rand() % choice_of_shapes);
  for (next_sh = shp_lst; new_shape_no; new_shape_no--)
    next_sh = next_sh -> next_shp;
}    /* get_next_shape */



static void do_blip(void)
{
  if (sound_on)
    sound(100);
  delay(40); nosound();
} /* do_blip */

static void end_noise(void)
{
  int i;
  if (!sound_on)
    return;
  for (i = 1000; i < 3000; i+= 10)
  {
    sound(i); delay(1);
  }
  nosound();
} /* end_noise */


static void   kill_row(int t_row)
{
  int x,y;
  for (y = t_row; y > 1; y--)
    for (x = 1; x < BLW - 1; x++)
      arena[x][y] = arena[x][y-1];
  for (x = 1; x < BLW - 1; x++)
      arena[x][1] = CLEAR;
  v_kill_row(t_row);
  p_arena(1,1,BLW-1,t_row);
}      /* kill_row */


static int   check_full_row(void)
{
  int y,x;
  int clear_found, result;

  result = FALSE;
  for (y = BLH - 2; y > 1; y--)
  {
    clear_found = FALSE;
    for (x = 1; x <= BLW -2; x++)
      if (arena[x][y] == CLEAR)
      {
	clear_found = TRUE;
	break;
      }
    if (clear_found)
      continue;
    lines_del++;  result = TRUE;
    kill_row(y);
    y++;
  }
  return(result);
} /* check_full_row */


static void  handle_keys(OBJ_TYPE *cur_obj)
{
  extern jmp_buf    end_game;
  int  i;           /* Index to Number of keys allowed per loop */

  static unsigned delay_period[MAX_LEVEL + 1] =
		{120, 98, 80, 66, 54, 44, 36, 29, 24,/* 20*/ 15};

  for (i = 0; i < NO_OF_KEY_PRESSES; i++)
  {
    if (kbhit())   /* get any keys */
      switch(getkey())
      {

        case LEFT_KEY:              /* Go Left */
          mv(left, cur_obj, HORIZ_MOVE);
	  break;

        case ROT_KEY:                /* Rotate */
          mv(anti, cur_obj, HORIZ_MOVE);
	  break;


        case RIGHT_KEY:             /* Go right */
          mv(right, cur_obj, HORIZ_MOVE);
	  break;

        case DROP_KEY:             /* Drop */
	case ' ':
          while (!mv(down,cur_obj, VERT_MOVE));
	  break;


        case LEVEL_KEY:             /* Level up */
          level = level++ % MAX_LEVEL;
	  shape_count  = 0;
          update_score(level, score, lines_del, next_sh, show_shape);
	  break;

        case 'p':                /* Pause game */
	case 'P':
	  if (!pause_game())
	    break;

        case ESC:                /* Quit game */
	  longjmp(end_game,1);
	  break;


        case 's':
	case 'S':
	  sound_on = !sound_on;
	  break;

	default:
	  /* Do nothing */
	  break;
      } /* switch */

    delay(delay_period[level]);  /* delay after action */
  } /* for */
}  /* handle_keys */



void   game()
{
  OBJ_TYPE *cur_obj;
  unsigned local_score;

  do
  {
    init_arena();
    p_arena(0,0,(BLW-1),(BLH-1));   /*  display blank arena */
    level = get_level();
    score = 0L; lines_del = 0;
    cur_obj = malloc(sizeof(OBJ_TYPE));
    shape_count = 0;
    get_next_shape(); /* get first shape */
    while (!insrt(cur_obj,next_sh))
    {
      get_next_shape();
      update_score(level, score, lines_del, next_sh, show_shape);
      handle_keys(cur_obj);  /* at top */

      for (local_score = 24 + 3*level;
  	   !mv(down,cur_obj, VERT_MOVE);
  	   local_score--)
        handle_keys(cur_obj);

      if (check_full_row())
        do_blip();
      score += local_score;
      if (((lines_del/10) > level) && (level < MAX_LEVEL))
      {
        level++;
	shape_count = 0;
      }
      if (!(++shape_count % MAX_SHAPE) && (level < MAX_LEVEL))
        level++;
    } /* while can insert */
    update_score(level, score, lines_del, next_sh, FALSE);
    end_noise();
    while (kbhit())   /* Empty keyboard buffer */
      getch();
  }
  while (get_another_go(score));   /* Dialogue with player between games */

} /* game */

int getkey(void)
{
  int key;

  if(!(key = getch()))
    key = 128 + getch();

  return(key);
}
