
/*
  This file includes all the internal equates and prototypes for the
  Soundscape digital audio driver.
*/

#include "driver.h"


/* Ensoniq gate-array chip defines ... */

#define ODIE            0       /* ODIE gate array */
#define OPUS            1       /* OPUS gate array */
#define MMIC            2       /* MiMIC gate array */    

/* relevant direct register defines - offsets from base address */
#define GA_HOSTCTL_OFF  2       /* host port ctrl/stat reg */
#define GA_ADDR_OFF     4       /* indirect address reg */
#define GA_DATA_OFF     5       /* indirect data reg */
#define GA_CODEC_OFF    8       /* for some boards CoDec is fixed from base */

/* relevant indirect register defines */
#define GA_DMAB_REG     3       /* DMA chan B assign reg */
#define GA_INTCFG_REG   4       /* interrupt configuration reg */
#define GA_DMACFG_REG   5       /* DMA configuration reg */
#define GA_CDCFG_REG    6       /* CD-ROM/CoDec config reg */
#define GA_HMCTL_REG	9	/* host master control reg */


/* AD-1848 or compatible CoDec defines ... */
/* relevant direct register defines - offsets from base */
#define CD_ADDR_OFF     0       /* indirect address reg */
#define CD_DATA_OFF     1       /* indirect data reg */
#define CD_STATUS_OFF   2       /* status register */

/* relevant indirect register defines */
#define CD_ADCL_REG	0	/* left DAC input control reg */
#define CD_ADCR_REG	1	/* right DAC input control reg */
#define CD_CDAUXL_REG   2       /* left DAC output control reg */
#define CD_CDAUXR_REG   3       /* right DAC output control reg */
#define CD_DACL_REG     6       /* left DAC output control reg */
#define CD_DACR_REG     7       /* right DAC output control reg */
#define CD_FORMAT_REG   8       /* clock and data format reg */
#define CD_CONFIG_REG   9       /* interface config register */
#define CD_PINCTL_REG   10      /* external pin control reg */
#define CD_UCOUNT_REG   14      /* upper count reg */
#define CD_LCOUNT_REG   15      /* lower count reg */
#define CD_XFORMAT_REG	28	/* extended format reg - 1845 record */
#define CD_XUCOUNT_REG	30	/* extended upper count reg - 1845 record */
#define CD_XLCOUNT_REG	31	/* extended lower count reg - 1845 record */

#define CD_MODE_CHANGE	0x40	/* mode change mask for addr reg */


/* some miscellaneous defines ... */
#define DMAC_SINGLE_OUT	0x48    /* DMA controller mode - single buffer, out */
#define DMAC_AUTO_OUT	0x58    /* DMA controller mode - auto-restart, out */
#define DMAC_SINGLE_IN	0x44    /* DMA controller mode - single buffer, in */
#define DMAC_AUTO_IN	0x54    /* DMA controller mode - auto-restart, in */

/* Some TypeDefs ... */
typedef struct {		/* DMA controller registers ... */
        short   addr;		/* address register, lower/upper */
        short   count;		/* address register, lower/upper */
        short   status;		/* status register */
        short   mask;		/* single channel mask register */
        short   mode;		/* mode register */
        short   clrff;		/* clear flip-flop register */
        short   page;		/* fixed page register */
} DMAC_REGS;


/* prototypes for internal driver functions */

short   GaRead(WORD reg);
void    GaWrite(WORD, short);

short   CdRead(WORD);
void    CdWrite(WORD, short);

short   SetFormat(WORD, short, short, short);

short   GetConfigEntry(char *, char *, FILE *);

void    interrupt far WaveIsr();

