.8086

; A simple TSR that hooks into int C0h to redirect audio from port C0h to another address.
; Used for the Lo-Tech Tandy Audio Card.

; The resident segment definitions must come before everything else.

ResidentSeg     segment para public 'Resident'
ResidentSeg     ends

EndResident     segment para public 'EndRes'
EndResident     ends

; Resident segment that holds the TSR code:

ResidentSeg     segment para public 'Resident'
                assume  cs:ResidentSeg, ds:nothing

OldIntC0        dd   ?


; MyIntC0-      The game will be patched to call int C0 instead of out C0, al 
;               whenever it wants to send a command to the SN76489.

MyIntC0         proc    far
                push dx
				mov dx, 0C0h
				out dx, al
				pop dx
				iret
MyIntC0         endp


ResidentSeg     ends


cseg            segment para public 'code'
                assume  cs:cseg, ds:ResidentSeg

Main            proc
                mov     ax, ResidentSeg
                mov     ds, ax
                mov     ax, 0
                mov     es, ax

; Patch into the INT C0 interrupt vectors. Note that the
; statements above have made ResidentSeg the current data segment,
; so we can store the old INT C0 and values directly into
; the OldIntC0 variables

                cli                             ;Turn off interrupts!
                mov     ax, es:[0C0h*4]
                mov     word ptr OldIntC0, ax
                mov     ax, es:[0C0h*4 + 2]
                mov     word ptr OldIntC0+2, ax
                mov     word ptr es:[0C0h*4], offset MyIntC0
                mov     word ptr es:[0C0h*4+2], seg ResidentSeg
                sti                             ;Okay, ints back on.

; We're hooked up, the only thing that remains is to terminate and
; stay resident.

                mov     ah, 62h                 ;Get this program's PSP
                int     21h                     ; value.

                mov     dx, EndResident         ;Compute size of program.
                sub     dx, bx
                mov     ax, 3100h               ;DOS TSR command.
                int     21h
Main            endp
cseg            ends

sseg            segment para stack 'stack'
stk             db      1024 dup (?)
sseg            ends
                end     Main