/*$Author:   BCRANE  $*/
/*$Date:   15 Jun 1992 10:15:58  $*/
/*$Header:   W:/sccs/inc/play.h_v   1.0   15 Jun 1992 10:15:58   BCRANE  $*/
/*$Log:   W:/sccs/inc/play.h_v  $
 * 
 *    Rev 1.0   15 Jun 1992 10:15:58   BCRANE
 * Initial revision.
*/
/*$Logfile:   W:/sccs/inc/play.h_v  $*/
/*$Modtimes$*/
/*$Revision:   1.0  $*/
/*$Workfile:   PLAY.H  $*/

    /*\
    |*|----=====< PLAY.H >====----
    |*|
    |*|  This module holds the various definitions for the
    |*|  ".VOC" file contents.
    |*|
    |*| Copyright (c) 1991, Media Vision, Inc.	All Rights Reserved.
    |*|
    \*/

    /*\
    |*| Sound Blaster ".VOC" file definition
    \*/

	typedef struct {
	    char     id[20];		/* name 			*/
	    unsigned voice_offset;	/* offset to data block 	*/
	    unsigned version;		/* version			*/
	    unsigned check_code;	/* garbage			*/
	} VOCHDR;


    /*\
    |*| Data Block Structures
    \*/

	/* types of data blocks 					*/

#define TERMINATOR	0x00		/* terminator block type	*/
#define VOICEDATA	0x01		/* voice data block		*/
#define VOICECONTINUE	0x02		/* more voice data block	*/
#define SILENCE 	0x03		/* silence period		*/
#define MARKER		0x04		/* marker for syncing		*/
#define ASCIITEXT	0x05		/* ascii zstring data		*/
#define REPEAT		0x06		/* repeat next blocks x times	*/
#define ENDREPEAT	0x07		/* end repeat marker		*/

	/* Common Header to each data block				*/

	    typedef struct {
		char btype;		/* block type			*/
		char bsize[3];		/* 24 bits for block size	*/
	    } bVOCDATAHDR;

	/* voice data block (#1)					*/

	    typedef struct {
		char btype;		/* block type			*/
		char bsize[3];		/* 24 bits for block size	*/
		char sampler;		/* sample rate			*/
		char packtype;		/* packing 8/4/2.6/2 bits	*/
	    } bVOCDATA;

	/* voice continuation (#2)					*/

	    typedef struct {
		char btype;		/* block type			*/
		char bsize[3];		/* 24 bits for block size	*/
	    } bCONTINUE;

	/* Silence (#3) 						*/

	    typedef struct {
		char btype;		/* block type			*/
		char bsize[3];		/* 24 bits for block size	*/
		int  period;		/* period in sample units	*/
		char sampler;		/* sample rate			*/
	    } bSILENCE;

	/* Marker (#4)							*/

	    typedef struct {
		char btype;		/* block type			*/
		char bsize[3];		/* 24 bits for block size	*/
		int  marker;		/* marker ID			*/
	    } bMARKER;

	/* ASCII zstring text (#5)					*/

	    typedef struct {
		char btype;		/* block type			*/
		char bsize[3];		/* 24 bits for block size	*/
		char text;		/* ascii zstring text		*/
	    } bASCII;

	/* Repeat Loop (#6)						*/

	    typedef struct {
		char btype;		/* block type			*/
		char bsize[3];		/* 24 bits for block size	*/
		char count;		/* # of times to repeat (-1)	*/
	    } bREPEAT;

	/* End Repeat Loop (#7) 					*/

	    typedef struct {
		char btype;		/* block type			*/
		char bsize[3];		/* 24 bits for block size	*/
	    } bENDREP;


    /*\
    |*|----====< ".WAV" file definition >====----
    |*|
    |*|     4 bytes 'RIFF'
    |*|     4 bytes <length>
    |*|     4 bytes 'WAVE'
    |*|     4 bytes 'fmt '
    |*|     4 bytes  <length>	    ; 10h - length of 'data' block
    |*|     2 bytes  01 	    ; format tag
    |*|     2 bytes  01 	    ; channels (1=mono, 2=stereo)
    |*|     4 bytes  xxxx	    ; samples per second
    |*|     4 bytes  xxxx	    ; average samples per second
    |*|     2 bytes  01/02/04	    ; block alignment
    |*|     2 bytes  08/16	    ; bits per sample
    |*|     4 bytes 'data'
    |*|     4 bytes <length>
    |*|       bytes <sample data>
    |*|
    \*/

    /* Wave format control block					*/

        typedef struct {
	    int  formatTag;		/* format category		*/
	    int  nChannels;		/* stereo/mono			*/
	    long nSamplesPerSec;	/* sample rate			*/
	    long nAvgBytesPerSec;	/* stereo * sample rate 	*/
	    int  nBlockAlign;		/* block alignment (1=byte)	*/
	    int  nBitsPerSample;	/* # byte bits per sample	*/
	} WaveInfo;

	typedef struct {
	    char name[4];
	    long length;
	    WaveInfo info;
	} WaveFormat;

    /* Data header which follows a WaveFormat Block			*/

        typedef struct {
	    char name[4];
	    unsigned long length;
	} DataHeader;

    /* Total Wave Header data in a wave file				*/

        typedef struct {
	    char name[4];
	    WaveFormat fmt;
	    DataHeader data;
	} WaveHeader;

    /* Riff wrapper around the WaveFormat Block (optional)		*/

	typedef struct {
	    char name[4];
	    long length;
	} RiffHeader;

    /* Riff wrapped WaveFormat Block					*/

	typedef struct {
	    RiffHeader riff;
	    WaveHeader wave;
	} RiffWave;


    /*\
    |*| end of PLAY.H
    \*/

