/*
    filename:   imdrv.h
    Synopsis:   functions prototypes for drivers module
    Date:       March the 19th 1991

COPYRIGHT (c) 1991  Matrox Electronic Systems Ltd.
All Rights Reserved

*/

#ifndef __I_DRIVERS_H__
#define __I_DRIVERS_H__

/* Need imseries.h for I_UNIX defines */
#ifndef __I_IMSERIES_H__
#include "imseries.h"
#endif /* __I_IMSERIES_H__ */

/* Need i_dll.h for FTYPE */
#ifndef __I_I_DLL_H__
#ifdef I_UNIX
#include <im_series/i_dll.h>
#else
#include "i_dll.h"
#endif /* I_UNIX */
#endif /* __I_I_DLL_H__ */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */
/* all prints in library go through im_printf */

short FTYPE iocldevice(int handle);
short FTYPE iodmfbarea(short fb,int handle,unsigned short xstart,
                       unsigned short ystart,unsigned short xend,
                       unsigned short yend,void _I_PTYPE *buf,
		       unsigned long bufsize);
void FTYPE iosdetag(short ressource);
void FTYPE iowtetag(short ressource);
short FTYPE ioiqetag(short ressource);
void FTYPE ioflush(void );
void FTYPE iogetbuf(short _I_PTYPE *buffer,short nwords);
short FTYPE iogeterror(void );
float FTYPE iogetf(void );
void FTYPE iogetfbuf(float _I_PTYPE *buffer,unsigned short nfloats);
short FTYPE iogetw(void );
void FTYPE ioputbuf(short _I_PTYPE *buffer,unsigned short nwords);
void FTYPE ioputf(float val);
void FTYPE ioputfbuf(float _I_PTYPE *buffer,unsigned short nfloats);
void FTYPE ioputmbuf(unsigned short _I_PTYPE * _I_PTYPE *buffers, 
					 unsigned short _I_PTYPE *ns, unsigned short n);
void FTYPE ioputtxt(char _I_PTYPE *buffer,unsigned short nchar);
void FTYPE ioputw(short word);
void FTYPE iostcursorpos(short x,short y);
void FTYPE iostrdmask ( unsigned long p0 );
void FTYPE iostwrmask ( unsigned long p0 );
void FTYPE iostovrdmask ( unsigned long p0 );
void FTYPE iostovwrmask ( unsigned long p0 );
short FTYPE ioiqrdfifo(void );
short FTYPE ioiqwrfifo(void );
void FTYPE iosditag(short device);
void FTYPE iowtitag(short device);
short FTYPE iolcxiload( char _I_PTYPE *filename, short flags );
short FTYPE ioldfbarea(short fb,int handle,unsigned short xstart,
                       unsigned short ystart,unsigned short xend,
                       unsigned short yend,void _I_PTYPE *buf,
					   unsigned long bufsize);
short FTYPE ioldshell (char _I_PTYPE *filename,short flags);

void FTYPE lscold(void );
void FTYPE lslibsync(void );
void FTYPE lswarm(void );
int FTYPE ioopdevice(unsigned long device,short flag);
short FTYPE iomapboard(unsigned short memflag, unsigned short memloc,
                       unsigned short memsiz, unsigned long far *bufsel,
                       unsigned short fh);
short FTYPE iordfbarea(short fb,short xstart,short ystart,short xend,
                       short yend,void _I_PTYPE *buf);
short FTYPE iordline(short fb,short dir,short xstart,short ystart,
                     short lenght,void _I_PTYPE *buf);
short FTYPE iordpixel(short fb,short x,short y,void _I_PTYPE *buf);
void FTYPE iorlmemdevice(int handle);
void FTYPE iorsdevice(int handle,short type);
short FTYPE iosldevice(int handle);
short FTYPE ioslmemdevice(int handle);
short FTYPE iowrfbarea(short fb,short xstart,short ystart,short xend,
                       short yend,void _I_PTYPE *buf);
short FTYPE iowrline(short fb,short dir,short xstart,short ystart,
                     short lenght,void _I_PTYPE *buf);
short FTYPE iowrpixel(short fb,short x,short y,void _I_PTYPE *buf);
unsigned short FTYPE lleeprom (unsigned short function, unsigned short address,
										 unsigned short data);
void FTYPE pchlprocess(void );
void FTYPE pchlprocqueue(unsigned short p0);

/* SHey 94/03/07 Changed for _I_HRDWTYPE for WATCOM compiler support */
/* It was defined as _I_PTYPE before' */
char _I_HRDWTYPE * FTYPE fpjprdmem(short p0);
char _I_HRDWTYPE * FTYPE fpjpwrmem(short p0);

/* bLem 94/01/11 added to patch index problem in ADR */
short FTYPE ioFlushIndexInADR(short _I_HRDWTYPE *adrAddr);

#ifdef __I_WIN_NT_H__
   #ifdef __BORLANDC__
      void * FTYPE get_i_glob_ptr(void);
      unsigned long  (* FTYPE get_i_v_base_address_table_ptr(void))[15][4];
      unsigned short (* FTYPE get_i_v_adrtable_ptr(void))[15][4];
      unsigned short (* FTYPE get_i_v_factable_ptr(void))[15];
      unsigned short (* FTYPE get_i_v_sizetable_ptr(void))[15];
   #else
      void *get_i_glob_ptr();
      unsigned long  (*get_i_v_base_address_table_ptr(void))[15][4];
      unsigned short (*get_i_v_adrtable_ptr(void))[15][4];
      unsigned short (*get_i_v_factable_ptr(void))[15];
      unsigned short (*get_i_v_sizetable_ptr(void))[15];
   #endif
#endif

#ifdef  __cplusplus
}
#endif /* __cplusplus */
#endif /* __I_DRIVERS_H__ */
