/*
    filename:  camlist.h

COPYRIGHT (c) 1990, 1991  Matrox Electronic Systems Ltd.
All Rights Reserved

*/

#ifndef __I_CAMLIST_H__
#define __I_CAMLIST_H__

/*/
*       Synopsis:   Header file that contains logical camera defines which
*                   corresponds to pcsllogcam() parameter.
*       Date:       90.02.01
*                                               
*       Anything requiring clarification:  
*         - Description is associated to each logical camera define. It 
*           includes :
*             . the type (RS170A, CCIR, MONOSHOT, LINE SCANNER, SLOW
*               SCAN), 
*             . the corresponding file that contains the structure, 
*             . pixel clock (P.clk),
*             . maximum resolution (Resol), 
*             . a testing status that tells if the camera has been tested 
*               at MATROX or not,
*             . and a target cameras if any with the corresponding mode if 
*               any.
*         - For more informations concerning the logical camera setup, see
*           the corresponding file that contains the structure and a 
*           descriptive header.
**/


#define I_RS170     0   /* Type:    RS170A,     File:   camrs170.c      */
                        /* P.clk.:  10 MHz,     Resol:  512Hx480V       */
                        /* Status:  Successfully tested at MATROX       */
                        /* Target cam.: I2SIAC500, mod.: IAC552BC       */
                        /*        mode: camera master                   */
                        /* Target cam.: Sony XC-77                      */
                        /*        mode: camera master, continuous scan  */
                        /*        cam.: DAGE-MTI CCD-72                 */
                        /*        mode: camera master, continuous scan  */

#define I_VIDEK     1   /* Type:    monoshot,   File:   videk.c         */
                        /* P.clk.:  10 MHz      Resol:  1280Hx1024V     */
                        /* Status:  Successfully tested at Matrox       */
                        /* Target cam.: VIDEK MEGAPLUS                  */
                        /*        mode: 6,7 (monoshot)                  */

#define I_COHU      2   /* Type:    RS170A,     File:   cohu.c          */
                        /* P.clk.:  14.318 MHz  Resol:  739Hx484V       */
                        /* Status:  Tested with 512Hx480V at MATROX     */
                        /* Target cam.: COHU ER1100AJ (8400P)           */
                        /*        mode: camera slave                    */

#define I_RTD8      3   /* Internally used */

#define I_RTD16     4   /* Internally used */
                        
#define I_RS170_HI  5   /* Type:    RS170A,     File:   rs170_hi.c      */
                        /* P.clk.:  12.5 MHz    Resol:  655Hx480V       */
                        /* Status:  Successfully tested at MATROX       */
                        /* Target cam.: Sony XC-77                      */
                        /*        mode: camera master, continuous scan  */
                        /*        cam.: DAGE-MTI CCD-72                 */
                        /*        mode: camera master, continuous scan  */

#define I_CCIR_LOW  6   /* Type:    CCIR,       File:   ccir_low.c      */
                        /* P.clk.:  10 MHz,     Resol:  518Hx574V       */
                        /* Status:  Successfully tested at MATROX       */
                        /* Target cam.: Sony XC-77CE                    */
                        /*        mode: camera master, continuous scan  */

#define I_CCIR_HI   7   /* Type:    CCIR,       File:   ccir_hi.c       */
                        /* P.clk.:  12.5 MHz,   Resol:  650Hx574V       */
                        /* Status:  Successfully tested at MATROX       */
                        /* Target cam.: Sony XC-77CE                    */
                        /*        mode: camera master, continuous scan  */

#define I_I2SLS     8   /* Type:    Line scan,  File:   i2sls.c         */
                        /* P.clk.:  2 MHz       Resol:  1728H           */
                        /* Status:  Test not completed                  */
                        /* Target cam.: I2SIDC100 mod: IDC131BC         */
                        /*              used with interface: ISM197     */
                        /*        mode: scanning                        */

#define I_I2SMS     9   /* Type:    Monoshot,   File:   i2sms.c         */
                        /* P.clk.:  9.458 MHz   Resol:  493Hx287V       */
                        /* Status:  Clock problem (manufacturer is      */
                        /*          supposed to send us a new camera    */
                        /*          with a continuous clock).           */
                        /* Target cam.: I2SIMC500 mod: IMC562BC         */
                        /*        mode: monoshot, non-interlaced,       */
                        /*              immediate reading               */

#define I_PA_81DX   10  /* Type:                File:   pa_81dx.c       */  
                        /* P.clk.:              Resol:                  */
                        /* Status:  Test not completed                  */

#define I_CID50A4A  11  /* Type:                File:   cid50a4a.c      */
                        /* P.clk.:              Resol:                  */
                        /* Status:  Test not completed                  */

#define I_CID50A4B  12  /* Type:                File:   cid50a4b.c      */
                        /* P.clk.:              Resol:                  */
                        /* Status:  Test not completed                  */

#define I_PROGRESS  13  /* Type:    RS170 PROG. File:   progress.c      */  
                        /* P.clk.:  10 MHz      Resol:  512Hx480V       */
                        /* Status:  Test not completed                  */

#define I_LC1901    14  /* Type:    Line scan,  File:   lc1901.c        */
                        /* P.clk.:  .020-10MHz  Resol:  1024H           */
                        /* Status:  Test not completed                  */
                        /* Target cam.: EG&G RETICON                    */
                        /*        mod.: LC1901HAN-011, HKN-011          */
                        /*        mode: LINE RESET feature not used     */

#define I_COHUH14M  15  /* Type:    RS170A      File:   cohuh14m.c      */
                        /* P.clk.:  14.318 MHz  Resol:  739Hx484V       */
                        /* Status:  Structure created, not tested       */
                        /* Target cam.: COHU ER1100AJ, 8400P or 4110    */
                        /*              (4115-1)                        */
                        /*        mode: camera master, RS170            */

#define I_CCIR_43   18  /* Type:    CCIR,       File:   ccir_hi.c       */
                        /* P.clk.:  14.8 MHz,   Resol:  765Hx574V       */
                        /* Status:  Successfully tested at MATROX       */
                        /* Target cam.: Sony XC-77CE                    */
                        /*        mode: camera master, continuous scan  */

#define I_JVC7100   19  /* Type:    Color, slowscan  File:  jvc7100.c   */
                        /* P.clk.:  19.661 MHz  Resol: 1024Hx978V       */
                        /* Status:  Successfully tested at Matrox with  */
                        /*          an interrupt driven shell           */
                        /* Target cam.: TKF7100U                        */

#define I_CLDNTSC   32  /* Type:    NTSC        File:   cldntsc.cam     */
                        /* P.clk.:  10 MHz      Resol:  512Hx480V       */
                        /* Target cam.: any NTSC camera (Ch 1)          */

#define I_CLDRGB    33  /* Type:    RGB (NTSC)  File:   cldrgb.cam      */
                        /* P.clk.:  10 MHz      Resol:  512Hx480V       */
                        /* Target cam.: any RGB camera in RS170         */

#define I_CLDYC     34  /* Type:    Y/C         File:   cldyc.cam       */
                        /* P.clk.:  10 MHz      Resol:  512Hx480V       */
                        /* Target cam.: any S-VHS camera in RS170       */

#define I_CLDNTSC3  35  /* Type:    NTSC        File:   cldntsc3.cam    */
                        /* P.clk.:  10 MHz      Resol:  512Hx480V       */
                        /* Target cam.: any NTSC camera (Ch 3)          */

#define I_CLDPAL_I  36  /* Type:    PAL         File:   cldpal_i.cam    */
                        /* P.clk.:  14.8 MHz    Resol:  768Hx576V       */
                        /* Target cam.: any PAL I standard (Ch 1)       */

#define I_COHU1810  37  /* Type:    NTSC RGB    File:   cohu1810.cam    */
                        /* P.clk.:  12.14 MHz   Resol:  640Hx480V       */
                        /* Target cam.: COHU 1810                       */

#define I_CLDPIRGB  38  /* Type:    PAL I RGB   File:   cldpirgb.cam    */
                        /* P.clk.:  14.8 MHz    Resol:  768Hx576V       */
                        /* Target cam.: any RGB camera in CCIR          */

#define I_CLDPALYC  39  /* Type:    PAL Y/C     File:   cldpalyc.cam    */
                        /* P.clk.:  14.8 MHz    Resol:  768Hx576V       */
                        /* Target cam.: any S-VHS camera in CCIR        */

/*------------------------- Empty entries ------------------------------*/
/* These ids can be used by the camera utilities (set_cam)              */

#define I_USERCAM0   3
#define I_USERCAM1   4
#define I_USERCAM2  16
#define I_USERCAM3  17
#define I_USERCAM4  21
#define I_USERCAM5  22
#define I_USERCAM6  23
#define I_USERCAM7  24
#define I_USERCAM8  25
#define I_USERCAM9  26
#define I_USERCAM10 27
#define I_USERCAM11 28
#define I_USERCAM12 29
#define I_USERCAM13 30
#define I_USERCAM14 31


/*------------------------- Other defines ------------------------------*/

/* define I_RTD_8  Does not exist any more in shells 2.1X */
/* define I_RTD_16 Does not exist any more in shells 2.1X */

#endif /* __I_CAMLIST_H__ */
