#include "imseries.h"
#include "imbind.h"
#include "proto.h"

/* 
Copyright (c) Matrox Electronics 1989. All rights reserved
 FUNCTION DEF : _distcolorspace
*/ 

extern unsigned long i_buff[];
extern unsigned short _I_PTYPE *i_buffers[];
extern unsigned short i_ns[];

#define SIZEOF_MATRIX 9

#define BUFFER_SIZE 12      /* parameters buffer size in words */

#ifdef ANSI
void FTYPE distcolorspace(long p0, long p1, long p2, long p3,
                          unsigned short _I_PTYPE *p4)
#else
FTYPE distcolorspace(p0, p1, p2, p3, p4)
long p0;
long p1;
long p2;
long p3;
unsigned short _I_PTYPE *p4;
#endif
{
    unsigned long *p;
	unsigned short _I_PTYPE * _I_PTYPE *buffers, *ns;

    /* set buffer for parameters */
    p = i_buff;

    *p++ = (SECOND_DEC | DISTCOLORSPACE);
    *p++ = (long) p0;
    *p++ = (long) p1;
    *p++ = (long) p2;
    *p++ = (long) p3;
    *p++ = (long)(SIZEOF_MATRIX);

    /* set buffer for buffers */
    buffers = i_buffers;
    /* first send  parameters */
    *buffers++ = (unsigned short *)i_buff;
    /* then the kernel values */
    *buffers = (unsigned short *)p4;

    /* set buffer for buffer sizes */
    ns = i_ns;
    /* parameter buffer size ( in words ) */
    *ns++ = BUFFER_SIZE;
    /* kernel array size ( in words ) */
    *ns = (unsigned short)(SIZEOF_MATRIX);

    /* send buffers */
    ioputmbuf ( i_buffers, i_ns, 2 );

} /* distcolorspace() */ 

