#include "imseries.h"
#include "imbind.h"
#include "proto.h"

/*
Copyright (c) Matrox Electronics 1989. All rights reserved
 FUNCTION DEF : _nbdfker
*/

extern unsigned long i_buff[];
extern unsigned short _I_PTYPE *i_buffers[];
extern unsigned short i_ns[];

#define BUFFER_SIZE 18 /* parameters buffer size in words */

#ifdef ANSI
void FTYPE nbdfker ( short p0, short p1, long p2, short p3, unsigned short p4,
                     short p5, short p6, unsigned short _I_PTYPE *p7 )
#else
FTYPE nbdfker ( p0, p1, p2, p3, p4, p5, p6, p7 )
short p0;
short p1;
long p2;
short p3;
unsigned short p4;
short p5;
short p6;
unsigned short _I_PTYPE *p7;
#endif
{
	unsigned long *p;
	unsigned short _I_PTYPE * _I_PTYPE *buffers, *ns;

	/* set buffer for parameters */
	p = i_buff;
	*p++ = (SECOND_DEC | NBDFKER);
	*p++ = (long) p0;
	*p++ = (long) p1;
	*p++ = p2;
	*p++ = (long) p3;
	*p++ = (unsigned long) p4;
	*p++ = (long) p5;
	*p++ = (long) p6;
	*p++ = (long)(p5*p6);

	/* set buffer for buffers */
	buffers = i_buffers;
	/* first send  parameters */
	*buffers++ = (unsigned short *)i_buff;
	/* then the kernel values */
	*buffers = p7;

    /* set buffer for buffer sizes */
    ns = i_ns;
    /* parameter buffer size ( in words ) */
    *ns++ = BUFFER_SIZE;
    /* kernel array size ( in words ) */
    *ns = (unsigned short)(p5*p6);

    /* send buffers */
	ioputmbuf (i_buffers, i_ns, 2);

} /* nbdfker() */
