/***************************************************************************
*
*   File name: ldshell.h
*   Date:     91.04.18
*   Description: #defines describing imdownl options
*
***************************************************************************/


#ifndef __I_LDSHELL_H__
#define __I_LDSHELL_H__

#if defined(I_MS_DOS) || defined(SYS5R4)
#include <stdlib.h>
#endif /* I_MS_DOS || SYS5R4 */

#if defined(I_MS_DOS) || defined(I_OS2)
#ifndef WIN_NT
#include <bios.h>                /* MSC5 lib */
#endif

#ifdef __TURBOC__
#define _TIME_GETCLOCK  0
#endif /* __TURBOC__ */

#endif

#ifdef  I_UNIX
#include <sys/types.h>
#endif


#ifdef  I_MS_DOS
#ifdef  PHAR_LAP
#define FAR       _far
#else
#define FAR       far
#endif
#define caddr_t   short far *
#endif

#ifdef  I_UNIX
#define FAR
#endif
#ifdef  I_OS2
#define caddr_t   short *
#endif

extern I_IMGLOB i_glob;

#define GSP_MIN_LOAD_ADDR         0xff800000L /* last megabyte */
#define GSP_MIN_LOAD_ADDR_4MB     0xfe000000L /* last 4 megabyte */

#define CONFIG_WORD               0x0c02      /* RR et RCA bus config:
                                                 written in config register */
#define SYSTEM_CONF_WORD          0x2         /* least significant nibble
                                                 in reset vector */
#define TSTV1  0x5a5a
#define TSTV2  0xa5a5

#define MULTIBUF_SIZE 4096               /* buffer to read coff files: size */

/* local ram window definitions */
#define WINDOW_LENGTH            0x1000L      /* number of 16 bits words */

/* host acces port size */
#define WINDOW_SIZE 8191

#ifdef I_UNIX
#define PATHSEPARATOR   ':'
#else
#define PATHSEPARATOR   ';'
#endif

/* reset vector address */
#define RESET_VECTOR    ((caddr_t)(window_base + EXEC_RSTVECT))  /*  */
#define NMI_VECTOR      ((caddr_t)(window_base + EXEC_NMIVECT))  /*  */


#define SHELLPATHENVAR  "IMSHELL"
#ifdef  I_UNIX
#define SHELLPATHDEFAULT "/usr/im_series/shell"
#else
#define SHELLPATHDEFAULT NULL
#endif



#endif /* __I_LDSHELL_H__ */
