/*
     filename:   fpu.h
     Synopsis:   functions prototypes for fpu module
     Date:       March the 19th 1991

COPYRIGHT (c) 1991  Matrox Electronic Systems Ltd.
All Rights Reserved

*/

#ifndef __I_FPU_H__
#define __I_FPU_H__

/* Need imseries.h for I_UNIX defines */
#ifndef __I_IMSERIES_H__
#include "imseries.h"
#endif /* __I_IMSERIES_H__ */

/* Need i_dll.h for FTYPE */
#ifndef __I_I_DLL_H__
#ifdef I_UNIX
#include <im_series/i_dll.h>
#else
#include "i_dll.h"
#endif /* I_UNIX */
#endif /* __I_I_DLL_H__ */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

void FTYPE fpfdcvfltint(short p0,short p1,short p2,long p3,short p4);
void FTYPE fpfdcvrectexp(short p0,short p1,short p2,short p3,short p4);
void FTYPE fpgtdfgtran(long p0,float p1,float p2,float p3,float p4,float p5,
                       float p6);
void FTYPE fpgtdfpersp(long p0,float p1,float p2,float p3,float p4,float p5,
                       float p6,float p7,float p8,float p9);
void FTYPE fputldfpucod(long p0);
void FTYPE fpfddoarithmetic(short p0,short p1,short p2,short p3,short p4);
void FTYPE fpfddoarithconst(short p0,short p1,short p2,short p3,float p4, 
                       float p5, short p6);
void FTYPE fpfddofft1d(short p0,short p1,short p2,short p3,short p4,short p5,
                       short p6,short p7);
void FTYPE fpfddofft2d(short p0,short p1,short p2,short p3,short p4,short p5,
                       short p6);
void FTYPE fpgtdogtran(long p0,long p1,long p2,long p3,long p4);
void FTYPE fpgtdopersp(long p0,long p1,long p2,long p3,long p4);
void FTYPE fpgtdoptgtran(long p0,long p1,long p2,long p3,float p4,float p5,
                         float p6,float p7,float p8,float p9,float p10,
                         float p11);
void FTYPE pcstfpuformat(unsigned long p0,unsigned long p1);
void FTYPE v2mdid(void );
void FTYPE v2mdorg(float p0,float p1);
void FTYPE v2mdrot(float p0);
void FTYPE v2mdset(float p0,float p1,float p2,float p3,float p4,float p5);

#ifdef  __cplusplus
}
#endif /* __cplusplus */
#endif /* __I_FPU_H__ */
