/*/  Function name:   v2gpmap
*
*    Note:  Use the C binding's "iogetw" function to retrieve the data.
*           The x screen coordinate is read first, then the y screen
*           coordinate.
*
*    Author:   Jean Dupre
*    Date:     March 17, 1988
*
*    Modification history:  
*
*    Calls:  ioputbuf:  send a buffer of words to the board.
*
*    Uses:  FIXPT data type.
*
*    Return value:   None
*/

#include "imseries.h"
#include "imbind.h"
#include "proto.h"

IMPORT  short  buff[];
IMPORT  short  *ptrbuff;


#ifdef ANSI
void FTYPE v2gpmap(FIXPT x, FIXPT y)
#else
FTYPE v2gpmap(x, y)
FIXPT  x, y;
#endif

    {
    ptrbuff = buff;

    *ptrbuff++ = 0x0091;

    LDFBUFF(ptrbuff, x);
    LDFBUFF(ptrbuff, y);
    
    ioputbuf(buff, 5);
    }


