/*/  Function name:  lsrdrst
*
*    Note:  The user must be sure that the read fifo is empty before sending
*           that command.
*
*    Author:   Jean Dupre
*    Date:     Feb 15, 1988
*
*    Modification history:  
*
*    Calls:  ioputbuf:  send a buffer of words to the board.
*            iogetbuf:  get a buffer of words from the board.
*
*    Uses:  None
*
*    Return value:  None
*/

#include  <stdio.h>
#include "imseries.h"
#include "imbind.h"
#include "proto.h"

#define   TEMPBUFFSIZE   1024
/*        Size of a disk cluster, 1024Kwords or 2048Kbytes */

GLOBAL unsigned short  tempbuff[TEMPBUFFSIZE];
/*        This buffer is also used by lswrrst(). lsrlrdrst() and lsrlwrrst() */

IMPORT  short  buff[];
IMPORT  short  *ptrbuff;


#ifdef ANSI
void FTYPE lsrdrst(short left, short top, short right, short bottom,
                   char _I_PTYPE *dest_filename)
#else
FTYPE lsrdrst(left, top, right, bottom, dest_filename)
short  left, top, right, bottom;
char  _I_PTYPE *dest_filename;
#endif

    {
    FILE    _I_PTYPE *fpw;                     /* Output file pointer */
    unsigned long  length;
    unsigned short  numwrite;

    ptrbuff = buff;

    *ptrbuff++ = 0x0020;
    *ptrbuff++ = left;
    *ptrbuff++ = top;
    *ptrbuff++ = right;
    *ptrbuff = bottom;

    ioputbuf(buff, 5);

    length = ((long)(right - left + 1) * (long)(bottom - top + 1) + 1) >> 1;

    fpw = fopen(dest_filename, "wb");

    while (length)
        {
        if (length > TEMPBUFFSIZE)
            {
            numwrite = TEMPBUFFSIZE;
            length -= TEMPBUFFSIZE;
            }
        else
            {
            numwrite = (unsigned short) length;
            length = 0;
            }

        iogetbuf((short *) tempbuff, numwrite);

        fwrite((char *)tempbuff, sizeof(short), numwrite, fpw);
        }

    fclose(fpw);
    }


