/*/  Function name:  lsclmodify
*
*    Author:   Jean Dupre
*    Date:     March 17, 1988
*
*    Modification history:  
*
*    Calls:  ioputmbuf:  send multiple buffers of words to the board.
*
*    Uses:  None
*
*    Return value:  None
*/

#include "imseries.h"
#include "imbind.h"
#include "proto.h"

IMPORT  short  buff[];
IMPORT  short  *ptrbuff;
IMPORT  unsigned short _I_PTYPE *i_buffers[];
IMPORT  unsigned short i_ns[];

#define BUFFER_SIZE 4 /* parameters buffer size in words */

#ifdef ANSI
void FTYPE lsclmodify(unsigned short command_list_num, short word_offset,
					  short num_words, short _I_PTYPE *wordptr)
#else
FTYPE lsclmodify(command_list_num, word_offset, num_words, wordptr)
unsigned short  command_list_num;
short  word_offset;
short  num_words;
short  _I_PTYPE *wordptr;
#endif

	{

	unsigned short _I_PTYPE * _I_PTYPE *buffers, _I_PTYPE *ns;

    /* set buffer for parameters */
    ptrbuff = buff;

    *ptrbuff++ = 0x0008;
    *ptrbuff++ = command_list_num;
    *ptrbuff++ = word_offset;
    *ptrbuff = num_words;

    /* set buffer for buffers */
    buffers = i_buffers;
    /* first send  parameters */
    *buffers++ = (unsigned short _I_PTYPE *)buff;
    /* then the words values */
    *buffers = (unsigned short _I_PTYPE *)wordptr;

    /* set buffer for buffer sizes */
    ns = i_ns;
    /* parameter buffer size ( in words ) */
    *ns++ = (unsigned short) BUFFER_SIZE;
    /* number of words ( in words ) */
    *ns = (unsigned short) num_words;

    /* send buffers */
    ioputmbuf ( i_buffers, i_ns, 2 );

    }


