            .386

; This assembles code compatible to Watcom 32 bit near model
; ----------------------------------------------------------
IFDEF WATCOM

_TEXT	SEGMENT  WORD PUBLIC 'CODE'
_TEXT	ENDS

_DATA	SEGMENT  WORD PUBLIC 'DATA'
_DATA	ENDS

DGROUP	GROUP _DATA

ASSUME	CS: _TEXT, DS: DGROUP, SS: DGROUP

	public   __dpmicpuid


_TEXT	SEGMENT

;
;  void _dpmicpuid ( void far *ptr );
;

__dpmicpuid proc near

;  assume  cs:CPUID_TEXT, ds:DATA, es:DATA, ss:nothing


   push   ebp
   mov    ebp,esp

   push   es
   push   edi

   les    edi,fword ptr [ebp+8] ; ptr : pointer to convert
   
   mov    ax, 0400h             ; Get CPU type
   int    31h
   xor    ch, ch
   add    cx, 4                 ; convert dpmi cpu type
                                ; to Matrox convention
   mov    es:[edi], cx          ; save CPU type

   pop    edi
   pop    es
   pop    ebp

   ret

__dpmicpuid endp

_TEXT	ENDS


; Assemble for linkage to MSC large memory model code.
; ----------------------------------------------------
ELSE

  DPMICPUID_TEXT      segment byte public 'CODE' USE16
  DPMICPUID_TEXT      ends

  DGROUP      group  _DATA,_BSS
              assume cs:DPMICPUID_TEXT,ds:DGROUP
  EXTRN       _cpuid:FAR
  _DATA       segment word public 'DATA' USE16
  d@          label  byte
  d@w         label  word
  _DATA       ends
  _BSS        segment word public 'BSS' USE16
  b@          label  byte
  b@w         label  word
  _BSS        ends
  DPMICPUID_TEXT      segment byte public 'CODE' USE16

  ;
  ;           void _dpmicpuid ( void far *ptr );
  ;
              assume cs:DPMICPUID_TEXT

  ;-----------------------------------


  IFDEF I_PASCAL     ; use pascal calling convention
  _DPMICPUID  proc   far
  ELSE
  __dpmicpuid proc   far
  ENDIF

              push   bp
              mov    bp,sp

              push   es
              push   di

              mov    ax, 1686h                   ; Check for real or protexted mode
              int    2fh
              or     ax, ax
              jnz    _real_cpuid

              les    di,dword ptr [bp+6]         ; cpu_info

              mov    ax, 0400h                   ; Get CPU type
              int    31h
              xor    ch, ch
              add    cx, 4                       ; convert dpmi cpu type
                                                 ; to Matrox convention
              mov    es:[di], cx                 ; save CPU type
              jmp _end

  _real_cpuid:
              les    di,dword ptr [bp+6]         ; cpu_info

              push   es                          ; cpu_info as parameter
              push   di

              call   _cpuid                      ; C call for real mode cpuid
              add    sp,4                        ; remove cpu_info from stack
              jmp _end

  _end:

              pop    di
              pop    es

              pop    bp

  IFDEF I_PASCAL
              ret    4
  _DPMICPUID  endp
  ELSE
              ret
  __dpmicpuid endp
  ENDIF

  ;-----------------------------------

  DPMICPUID_TEXT      ends

  _DATA       segment word public 'DATA'
  s@          label  byte
  _DATA       ends
  DPMICPUID_TEXT      segment byte public 'CODE'
  DPMICPUID_TEXT      ends

  IFDEF I_PASCAL
              public _DPMICPUID
  ELSE
              public __dpmicpuid
  ENDIF

; End of the "IFDEF WATCOM"
; -------------------------
ENDIF

            end
