/*
    filename :  rlmemdev.c

COPYRIGHT (c) 1989, 1990, 1991  Matrox Electronic Systems Ltd.
All Rights Reserved

*/

#include <stdio.h>
#include "imseries.h"
#include "imbind.h"
#include "proto.h"

extern  I_IMGLOB    i_glob;

/*/     Function:   iorlmemdevice()
*       Synopsis:   release direct vram communication channel
*
*       Date:       May 5, 1990
*
*       Parameter:  int handle ; device handle
*                                               
*       Return value:   no return value
**/

#ifdef  ANSI
void FTYPE iorlmemdevice(int handle)
#else
FTYPE iorlmemdevice(handle)
int handle;
#endif
{
#if ( defined ( I_MS_DOS ) || defined ( I_PHYSMAP ))

    short device = handle;

#endif

#ifdef  I_UNIX

    /* no action to be taken if device not selected */
    if (i_glob.vram != handle)
        return;

    /* release */
    ioctl(handle, IMG_RLMEMDEV, NULL);

    /* remove from structure */
    i_glob.vram = -1;
    i_glob.vrammap = NULL;
    i_glob.vramhra = NULL;

#endif

#ifdef  I_OS2

    /* no action to be taken if device not selected */
    if (i_glob.vram != handle)
        return;

    /* release */
    DosDevIOCtl( 0L,
                 0L,
                 (USHORT) I_RL_FBAREA,
                 (USHORT) 0x80,
                 (HFILE)  i_glob.board);

    /* remove from structure */
    i_glob.vram = -1;
    i_glob.vrammap = NULL;
    i_glob.vramhra = NULL;

#endif

#ifdef  I_MS_DOS

    /* Check if new device was opened. */
    if ( i_glob.img_addr[device] )
        {

        /* Check if current board opened. */
        if ( i_glob.img_addr[i_glob.vram_dev] )
            /* disable it if so. */
            IMG_DISABLE(i_glob.vram_dev);

        /* undefine  */
        i_glob.vram = -1;
        i_glob.vram_dev  = -1;
        i_glob.vrammap   = (IMGMAP *)NULL;

        i_glob.vramhra = (IMGHRA *)NULL;

        }
#endif

} /* iorlmemdevice() */ 
