/*
    filename :  iogetbuf.c

COPYRIGHT (c) 1989, 1990, 1991  Matrox Electronic Systems Ltd.
All Rights Reserved

*/

/* all conditionnal compilations switches in imseries.h */

#include "imseries.h"
#include "imbind.h"
#include "proto.h"

extern  I_IMGLOB    i_glob;

/*/     Function:   iogetbuf()
*       Synopsis:   This routine gets a buffer of data from the FIFO.
*       Date:       January 23rd 1990
*       param:      --- none ---
*                                               
*       returns:    no return value.
**/

#ifdef  ANSI
void FTYPE iogetbuf( short _I_PTYPE *buffer, short nwords )
#else
FTYPE iogetbuf( buffer, nwords )
short _I_PTYPE *buffer, nwords;
#endif
{
#ifdef  I_UNIX

    I_IOBUF iobuf;

    iobuf.buffer = buffer;
    iobuf.nwords = nwords;

    ioctl(i_glob.board, IMG_READ, &iobuf);

#endif

#ifdef  I_MS_DOS

    register short   available_words;

#ifdef PHAR_LAP
    _far short *fifobase;
#else
    short far *fifobase;
#endif

    fifobase = i_glob.imghra -> rdfifo;

   do   {

        /*  First we should evaluate the amount of data available at the
            read FIFO.  This may prove to be a bit trickier in the PC low
            map, because of a HW bug associated with the FIFO count.
        */

#ifdef  PC_LOW_MAP

        /*  The read FIFO count sometimes tends to exaggerate in the PC
            low map. This occurs when the count actually crosses a 256
            count boundary while the host is fetching the count. In these
            cases, the count returned will declare 256 more entries than
            what is really available. Futhermore the low byte of the count
            will probably be 0.
        */

        available_words = IOread_count;

        if ( available_words > 256 )
            available_words -= 256;
        
#else
        /*  The FIFO will return a true count. This count is needed to
            establish if the buffer can be read in a single pass or not.
        */

        available_words = IOread_count;
#endif

        /*  Now the variable 'available_words' contains the maximum size
            available at this time. We will fetch in this pass as many
            words as possible, never exceeding the requested buffer size.
        */

        available_words = ( available_words < nwords ) ? available_words
         : nwords;


        /*  We now remove from the count of words remaining to be fetched,
            the amount that we will be reading in this pass. This keep its
            up to date.
        */

        nwords -= available_words;


        /*  This is where the buffer is fetched. On some system, a string
            move expression leads to more efficient speed.
        */

        while ( available_words-- )
            *buffer++ = *fifobase;

        }
   while ( nwords );        /* Loop until all done. */

#endif

#ifdef  I_OS2

  unsigned short num;
  PUSHORT pnum = &num;
  num = nwords;

  DosDevIOCtl( (PUSHORT) buffer,
               (PUSHORT) pnum,
               (USHORT)  I_READ_BUF_FIFO,
               (USHORT)  0x80,
               (HFILE)   i_glob.board );
#endif

} /* iogetbuf() */ 
