#include "imseries.h"
#include "imbind.h"
#include "proto.h"

/* 
Copyright (c) Matrox Electronics 1989. All rights reserved
 FUNCTION DEF : _nbdfmker
*/ 

extern unsigned long i_buff[];
extern unsigned short _I_PTYPE *i_buffers[];
extern unsigned short i_ns[];

#define	BUFFER_SIZE	10	/* parameters buffer size in words */

#ifdef ANSI
void FTYPE nbdfmker(short p0, short p1, short p2, short _I_PTYPE *p3)
#else
FTYPE nbdfmker(p0, p1, p2, p3)
short p0;
short p1;
short p2;
short _I_PTYPE *p3;
#endif
{
	unsigned long *p;
	unsigned short _I_PTYPE * _I_PTYPE *buffers, *ns;

	p = i_buff;

	/* set buffer for parameters */
	*p++ = (SECOND_DEC | NBDFMKER);
	*p++ = (long) p0;
	*p++ = (long) p1;
	*p++ = (long) p2;
	*p++ = (long) p2;

    /* set buffer for buffers */
    buffers = i_buffers;
    /* first send  parameters */
    *buffers++ = (unsigned short *)i_buff;
    /* then the kernel values */
    *buffers = (unsigned short _I_PTYPE *)p3;

    /* set buffer for buffer sizes */
    ns = i_ns;
    /* parameter buffer size ( in words ) */
    *ns++ = BUFFER_SIZE;
    /* kernel array size ( in words ) */
    *ns = (unsigned short) p2;

    /* send buffers */
    ioputmbuf ( i_buffers, i_ns, 2 );
}


