/*/  Function name:  lsfbm
*
*    Author:   Jean Dupre
*    Date:     March 17, 1988
*
*    Modification history:  
*
*    Calls:  ioputmbuf:  send multiple buffers of words to the board.
*
*    Uses:  None
*
*    Return value:  None
*/

#include "imseries.h"
#include "imbind.h"
#include "proto.h"

IMPORT  short  buff[];
IMPORT  short  *ptrbuff;
IMPORT  unsigned short _I_PTYPE *i_buffers[];
IMPORT  unsigned short i_ns[];

#define BUFFER_SIZE 1    /* parameters buffer size in words */

#ifdef ANSI
void FTYPE lsfbm(unsigned short bm_length, unsigned short _I_PTYPE *bm_data_ptr)
#else
FTYPE lsfbm(bm_length, bm_data_ptr)
unsigned short  bm_length;
unsigned short  _I_PTYPE *bm_data_ptr;
#endif

	{
	unsigned short _I_PTYPE * _I_PTYPE *buffers, _I_PTYPE *ns;

	/* set buffer for parameters */
	ptrbuff = buff;

    *ptrbuff = 0x012A;

    /* set buffer for buffers */
    buffers = i_buffers;
    /* first send  parameters */
    *buffers++ = (unsigned short _I_PTYPE *)buff;
    /* then the structure values */
    *buffers = bm_data_ptr;

    /* set buffer for buffer sizes */
    ns = i_ns;
    /* parameter buffer size ( in words ) */
    *ns++ = (unsigned short) BUFFER_SIZE;
    /* structure size ( in words ) */
    *ns = bm_length;

    /* send buffers */
    ioputmbuf ( i_buffers, i_ns, 2 );

    }


