/*
    filename :  iogetfbu.c

COPYRIGHT (c) 1989, 1990, 1991  Matrox Electronic Systems Ltd.
All Rights Reserved

*/

#include "imseries.h"
#include "imbind.h"
#include "proto.h"

extern  I_IMGLOB    i_glob;

/*/     Function:   iogetfbuf()
*       Synopsis:   This routine gets a buffer of floats.
*       Date:       January 23rd 1990
*       param:      --- none ---
*                                               
*       returns:    word
**/

#ifdef ANSI
void FTYPE iogetfbuf(float _I_PTYPE *buffer, unsigned short nfloats)
#else
FTYPE iogetfbuf( buffer, nfloats )
float _I_PTYPE *buffer;
unsigned short nfloats;
#endif
{
    register short  available_floats;

    do  {

        /* Evaluate the amount of longs that can readily be received.   */

        available_floats = IOread_count >> 1;


        /* Get as many as possible, up to a maximum of nfloats. */

        available_floats = ( (unsigned short) available_floats < nfloats ) ?
            available_floats : nfloats;


        /* Keep track of the amount being received. */

        nfloats -= available_floats;


        /* First word is the LOW part, second one becomes the HIGH part. */

        while ( available_floats-- )
            *buffer++ = (float) ((( IOread ) + ( IOread << 16 )) / FLOATfactor );

        }   while ( nfloats );  /* Loop until all done. */

} /* iogetfbuf() */ 
