/*
    filename :  glob.c

COPYRIGHT (c) 1989, 1990, 1991  Matrox Electronic Systems Ltd.
All Rights Reserved

*/

#include <stdio.h>
#include "imseries.h"
#include "imbind.h"
#include "proto.h"

/* buffer for ioputbuf() parameter. used mainly by graphic routines */
short  buff[CBUFFLENGTH];

/* Pointer to shorts (16 bits signed integer) */
short  *ptrbuff;

/* Image global array to compile parameters for ioputbuf() routine. */
unsigned long i_buff[I_BUFFLENGTH];

/* buffers used for calling ioputmbuf() */
unsigned short _I_PTYPE *i_buffers[I_MAXMBUF];
unsigned short i_ns[I_MAXMBUF];

/* Globals to map to any of the available boards.   */

/* if img_addr is NULL, not a physical board.   */
/* if img_fd   is NULL, not a file device.      */


/* global structure with default settings */

#ifdef  I_UNIX

I_IMGLOB    i_glob = {

    {
    NULL,	/* List of device driver names and path */
    "/dev/img0",  "/dev/img1",  "/dev/img2",  "/dev/img3",
    "/dev/img4",  "/dev/img5",  "/dev/img6",  "/dev/img7",
    "/dev/img8",  "/dev/img9",  "/dev/img10", "/dev/img11",
    "/dev/img12", "/dev/img13", "/dev/img14", "/dev/img15",
    "/dev/img16", "/dev/img17", "/dev/img18", "/dev/img19",
    "/dev/img20", "/dev/img21", "/dev/img22", "/dev/img23",
    "/dev/img24", "/dev/img25", "/dev/img26", "/dev/img27",
    },
    -1,                 /* no valid handle to current board      */
    -1,                 /* no valid handle to current mem device */
    0,                  /* default channel not yet defined */
#ifdef  I_PHYSMAP
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
     -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,},
    0,			/* img_dev  : current FIFO device   */
    0,			/* img_unit : current FIFO HRA unit */
    0,			/* vram_dev : current VRAM device   */
    0,			/* vram_unit: current VRAM HRA unit */
    NULL,
    NULL,
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
    { NULL, NULL, NULL, NULL, NULL, NULL, NULL,
      NULL, NULL, NULL, NULL, NULL, NULL, NULL,
      NULL, NULL, NULL, NULL, NULL, NULL, NULL,
      NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL },
    { NULL, NULL, NULL, NULL, NULL, NULL, NULL,
      NULL, NULL, NULL, NULL, NULL, NULL, NULL,
      NULL, NULL, NULL, NULL, NULL, NULL, NULL,
      NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL },

#endif
};

#endif

#ifdef  I_MS_DOS

I_IMGLOB    i_glob = {
    -1, /* board */
    -1, /* vram */
    0,  /* channel */
    0,  /* img_dev */
    0,  /* img_unit */
    0,  /* vram_dev */
    0,  /* vram_unit */
    (IMGMAP *)NULL,  /* imgmap */
    (IMGMAP *)NULL,  /* vrammap */
    { 0, 0, 0, 0, 0, 0, 0, 0, 0 },  /* img_fd */
      {
      (IMGMAP *)NULL,
      (IMGMAP *)NULL,
      (IMGMAP *)NULL,
      (IMGMAP *)NULL,
      (IMGMAP *)NULL,    /* img_addr */
      (IMGMAP *)NULL,
      (IMGMAP *)NULL,
      (IMGMAP *)NULL,
      (IMGMAP *)NULL
      },
    (IMGHRA *)NULL,      /* imghra */
    (IMGHRA *)NULL,      /* vramhra */
    { 0, 0, 0, 0, 0, 0, 0, 0, 0 },   /* keep_hctrl */
    0x00F00000L,         /* high_map */
    MYSTERY_CPU          /* host cpu type (0xFF => unknown) */
};


#endif


#ifdef  I_OS2

I_IMGLOB    i_glob = {

    {
    NULL,
    "$LOAO",
    "$LOAO",
    "$LOAO",
    "$LOAO",
    "$LOAO",
    "$LOAO",
    "$LOAO",
    "$LOAI",
    "$LOAI",
    "$LOAI",
    "$LOAI",
    "$LOAI",
    "$LOAI",
    "$LOAI",
    "$LIAO",
    "$LIAO",
    "$LIAO",
    "$LIAO",
    "$LIAO",
    "$LIAO",
    "$LIAO",
    "$LIAI",
    "$LIAI",
    "$LIAI",
    "$LIAI",
    "$LIAI",
    "$LIAI",
    "$LIAI",
    },

    -1,                 /* no valid handle */
    -1,                 /* no valid handle */
    0,                  /* default channel not yet defined */
    CPU_80386,

#ifdef  I_PHYSMAP
    0,
    0,
    NULL,
    NULL,
    0,
    0,
    NULL,
    NULL,
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
     -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,},
    { NULL, NULL, NULL, NULL, NULL, NULL, NULL,
      NULL, NULL, NULL, NULL, NULL, NULL, NULL,
      NULL, NULL, NULL, NULL, NULL, NULL, NULL,
      NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
#endif
};

#endif
