;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;	#     #
;	#  #  #    ##    #####   #    #     #    #    #   ####
;	#  #  #   #  #   #    #  ##   #     #    ##   #  #    #
;	#  #  #  #    #  #    #  # #  #     #    # #  #  #
;	#  #  #  ######  #####   #  # #     #    #  # #  #  ###
;	#  #  #  #    #  #   #   #   ##     #    #   ##  #    #
;	 ## ##   #    #  #    #  #    #     #    #    #   ####
;
;	DO NOT MODIFY, ERASE, OR MOVE THIS FILE.  IT IS REQUIRED
;	FOR PROPER OPERATION OF THE IDVIEW COMMANDS IN THE GL
;	DISPLAY DRIVER FOR AUTOCAD R12.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; Command:	gl_init
;
; Function:	Read needed SYSVARs and write them to a file.
;		The order of the variables written to the output file 
;		must remain unchanged.
;
; Creates:	./@sysvar.dat
;	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun gl_init ( / a f i j k l s)	
	(setq s (getvar "CMDECHO"))
	(setvar "CMDECHO" 0)
	(setq a (getvar "AUNITS"))
	(setq l (getvar "LUNITS"))
	(setvar "AUNITS" 0)		; Set Angle units to decimal degrees
	(setvar "LUNITS" 2)		; Set Linear units to decimal
	
	(setq f (open "./@sysvar.dat" "w"))

	(setq k (getvar "BACKZ"))
	(setq j (strcat "BACKZ = " (rtos k 2)))
	(write-line j f)

	(setq k (getvar "EXTMAX"))
	(setq j (strcat "EXTMAX = "(rtos (car k) 2)","(rtos(cadr k) 2)","(rtos(caddr k) 2)))
	(write-line j f)

	(setq k (getvar "EXTMIN"))
	(setq j (strcat "EXTMIN = "(rtos (car k) 2)","(rtos(cadr k) 2)","(rtos(caddr k) 2)))
	(write-line j f)

	(setq k (getvar "FRONTZ"))
	(setq j (strcat "FRONTZ = " (rtos k 2)))
	(write-line j f)

	(setq k (getvar "LENSLENGTH"))
	(setq j (strcat "LENSLENGTH = " (rtos k 2)))
	(write-line j f)

	(setq i (getvar "TARGET"))
	(setq k (trans i 1 0))
	(setq j (strcat "TARGET = "(rtos (car k) 2)","(rtos(cadr k) 2)","(rtos(caddr k) 2)))
	(write-line j f)

	(setq k (getvar "UCSORG"))
	(setq j (strcat "UCSORG = "(rtos (car k) 2)","(rtos(cadr k) 2)","(rtos(caddr k) 2)))
	(write-line j f)

	(setq k (getvar "UCSXDIR"))
	(setq j (strcat "UCSXDIR = "(rtos (car k) 2)","(rtos(cadr k) 2)","(rtos(caddr k) 2)))
	(write-line j f)

	(setq k (getvar "UCSYDIR"))
	(setq j (strcat "UCSYDIR = "(rtos (car k) 2)","(rtos(cadr k) 2)","(rtos(caddr k) 2)))
	(write-line j f)

	(setq i (getvar "VIEWCTR"))
	(setq k (trans i 1 0))
	(setq j (strcat "VIEWCTR = "(rtos (car k) 2)","(rtos(cadr k) 2)","(rtos(caddr k) 2)))
	(write-line j f)

	(setq i (getvar "VIEWDIR"))
	(setq k (trans i 1 0))
	(setq j (strcat "VIEWDIR = "(rtos (car k) 2)","(rtos(cadr k) 2)","(rtos(caddr k) 2)))
	(write-line j f)

	(setq k (getvar "VIEWMODE"))
	(setq j (strcat "VIEWMODE = " (rtos k 2 0)))
	(write-line j f)

	(setq k (getvar "VIEWSIZE"))
	(setq j (strcat "VIEWSIZE = " (rtos k 2)))
	(write-line j f)

	(setq k (getvar "VIEWTWIST"))
	(setq j (strcat "VIEWTWIST = " (angtos k 0)))
	(write-line j f)

	(setq i (getvar "VSMAX"))
	(setq k (trans i 1 0))
	(setq j (strcat "VSMAX = "(rtos (car k) 2)","(rtos(cadr k) 2)","(rtos(caddr k) 2)))
	(write-line j f)

	(setq i (getvar "VSMIN"))
	(setq k (trans i 1 0))
	(setq j (strcat "VSMIN = "(rtos (car k) 2)","(rtos(cadr k) 2)","(rtos(caddr k) 2)))
	(write-line j f)

	(setq k (getvar "WORLDUCS"))
	(setq j (strcat "WORLDUCS = " (rtos k 2 0)))
	(write-line j f)

	(close f)	

	(setvar "AUNITS" a)		; Restore Angle units setting
	(setvar "LUNITS" l)		; Restore Linear units setting
	(setvar "CMDECHO" s)
) (gl_init)
