/***************************************************************************
 File: sxview.c

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 You may use this Sample Code any way you please provided you do not resell 
 the code and that this notice (including the above copyright notice) is 
 reproduced on all copies.  THIS SAMPLE CODE IS PROVIDED "AS IS", WITHOUT 
 WARRANTY OF ANY KIND, AND GO CORPORATION EXPRESSLY DISCLAIMS ALL IMPLIED 
 WARRANTIES, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF 
 MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT WILL GO 
 CORPORATION BE LIABLE TO YOU FOR ANY CONSEQUENTIAL,INCIDENTAL, OR INDIRECT 
 DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE THIS SAMPLE CODE.
			  
 $Revision:   1.0  $
   $Author:   aloomis  $
     $Date:   13 Aug 1992 12:15:46  $

 This file contains the class definition and methods for clsSXView.

****************************************************************************/
#ifndef GWIN_INCLUDED
#include <gwin.h>
#endif

#ifndef XGESTURE_INCLUDED
#include <xgesture.h>
#endif

#ifndef INTL_INCLUDED
#include <intl.h>
#endif

#ifndef SXAPP_INCLUDED
#include "sxapp.h"
#endif
#include "methods.h"

/*
 * Respond to msgGWinGesture
 *
 * Intercept _all_ gestures, except Check and Flick Up & Down for the
 * TextView. This makes the TextView effectively read-only, while still being
 * able to insert characters programmatically. This is the only reason
 * clsTextView is sub-classed. Note however than copy/move of objects is still
 * possible.
 */
MsgHandlerArgType(SXViewGesture, P_GWIN_GESTURE)
{
	STATUS s;

	Dbg(Debugf(U_L("SXViewGesture >>"));)

	if (msg == msgGWinForwardedGesture)
		ObjCallRet(msgGWinTransformGesture, self, pArgs, s);

#ifdef PP1_0
	switch (pArgs->msg) {
#else 
	switch (pArgs->gesture) {
#endif
		case xgsCheck:
		case xgsFlickUp:
		case xgsFlickDown:
			return (ObjectCallAncestor(msg, self, pArgs, ctx));
		break;
	}

	Dbg(Debugf(U_L("<< SXViewGesture"));)

	return stsRequestDenied;
	MsgHandlerParametersNoWarning;
} /* SXViewGesture */

/*
 * Initialize clsSXView.
 */
STATUS EXPORTED ClsSXViewInit(void)
{
	CLASS_NEW		new;
	STATUS			s;

	ObjCallRet(msgNewDefaults, clsClass, &new, s);
	new.object.uid = clsSXView;
	new.cls.pMsg = clsSXViewTable;
	new.cls.ancestor = clsTextView;
	new.cls.size = 0;
	new.cls.newArgsSize = SizeOf(TV_NEW);
	ObjCallRet(msgNew, clsClass, &new, s);

	return stsOK;
} /* ClsSXViewInit */
